/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.type.time;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.jgoodies.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.cxbox.intellij.community.common.util.DialogUtil;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.wigdet.fields.field.type.time.TimeFormatContributor;
import org.cxbox.intellij.community.wigdet.fields.field.type.time.TimeFormatVariant;
import org.jetbrains.annotations.NotNull;

public class TimeFormatInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            TimeFormatInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            TimeFormatInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        Arrays.stream(file.getChildren()).filter(Objects::nonNull).forEach(arg_0 -> this.lambda$checkFile$0(manager, (List)descriptors, project, module, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void extracted(@NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> descriptors, @NotNull PsiElement c, @NotNull Project project, @NotNull Module module) {
        if (manager == null) {
            TimeFormatInspection.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            TimeFormatInspection.$$$reportNull$$$0(3);
        }
        if (c == null) {
            TimeFormatInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            TimeFormatInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            TimeFormatInspection.$$$reportNull$$$0(6);
        }
        if (TimeFormatContributor.Holder.TIME_FIELD_PATTERN.accepts((Object)c) && c instanceof JsonStringLiteral) {
            JsonStringLiteral literal = (JsonStringLiteral)c;
            String value = JsonFacade.safeGetValueAsString((PsiElement)literal);
            if (Strings.isBlank((String)value)) {
                descriptors.add(TimeFormatInspection.getProblemDescriptor(manager, "The format is incorrect, use autocomplete.", new TextRange(1, value.length() + 1), literal));
            } else if (!TimeFormatInspection.getAllAvailableFormatOptions().contains(value)) {
                descriptors.add(TimeFormatInspection.getProblemDescriptor(manager, "The format cannot be empty, use autocomplete.", new TextRange(1, value.length() + 1), literal));
            }
        } else {
            Arrays.stream(c.getChildren()).forEach(c2 -> this.extracted(manager, descriptors, (PsiElement)c2, project, module));
        }
    }

    private static ProblemDescriptor getProblemDescriptor(@NotNull InspectionManager manager, @NotNull String msg, @NotNull TextRange textRange, @NotNull JsonStringLiteral format) {
        if (manager == null) {
            TimeFormatInspection.$$$reportNull$$$0(7);
        }
        if (msg == null) {
            TimeFormatInspection.$$$reportNull$$$0(8);
        }
        if (textRange == null) {
            TimeFormatInspection.$$$reportNull$$$0(9);
        }
        if (format == null) {
            TimeFormatInspection.$$$reportNull$$$0(10);
        }
        return manager.createProblemDescriptor(format.getOriginalElement(), textRange, msg, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new Fix(format)});
    }

    private static List<String> getAllAvailableFormatOptions() {
        return Arrays.stream(TimeFormatVariant.values()).map(TimeFormatVariant::getFormat).toList();
    }

    public static String showAndGetFormat(@NotNull Project project) {
        List<String> variants;
        int choosedFormatIndex;
        if (project == null) {
            TimeFormatInspection.$$$reportNull$$$0(11);
        }
        if ((choosedFormatIndex = DialogUtil.getDialogChooseOneStringElement(project, variants = TimeFormatInspection.getAllAvailableFormatOptions(), "", "Select a format")) < 0) {
            return "";
        }
        return variants.get(choosedFormatIndex);
    }

    private /* synthetic */ void lambda$checkFile$0(InspectionManager manager, List descriptors, Project project, Module module, PsiElement c) {
        this.extracted(manager, descriptors, c, project, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/type/time/TimeFormatInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extracted";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getProblemDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "showAndGetFormat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record Fix(JsonStringLiteral literal) implements LocalQuickFix
    {
        @NotNull
        public String getName() {
            return "Select correct value";
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Select correct value";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            QuickFixUtils.clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/type/time/TimeFormatInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

