/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.general.Injection;
import com.intellij.lang.injection.general.LanguageInjectionContributor;
import com.intellij.lang.injection.general.SimpleInjection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.FieldMetaBuilderUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.language.SimpleLanguage;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimpleLangToPlatformActionInjector
implements LanguageInjectionContributor {
    public static final String ACTION_PKG_WITHOUT_PLATFORM_PREFIX = ".core.service.action";
    @NotNull
    public static final ElementPattern<PsiLiteral> ACTION_KEY_PATTERN = StandardPatterns.or((ElementPattern[])new ElementPattern[]{JavaUtil.PsiJavaElementPatternFacade.psiLiteralString().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("action")).withParameterCount(2)), JavaUtil.PsiJavaElementPatternFacade.psiLiteralString().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("add")).withParameterCount(2))});
    private static final Logger LOG = Logger.getInstance(SimpleLangToPlatformActionInjector.class);

    public static boolean isActionNamedElement(PsiElement context) {
        if (!(context instanceof PsiLiteralExpression)) {
            return false;
        }
        if (!(context.getContext() instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement psiElement = context.getContext().getContext();
        if (!(psiElement instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression mCall = (PsiMethodCallExpression)psiElement;
        if (!ACTION_KEY_PATTERN.accepts((Object)context)) {
            return false;
        }
        PsiMethod psiMethod = mCall.resolveMethod();
        if (psiMethod == null) {
            return false;
        }
        PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiMethod.getReturnType());
        if (targetClass == null) {
            return false;
        }
        String returnTypeQN = targetClass.getQualifiedName();
        if (returnTypeQN == null || !returnTypeQN.startsWith(Cache.PLATFORM_1 + ACTION_PKG_WITHOUT_PLATFORM_PREFIX) && !returnTypeQN.startsWith("org.cxbox.core.service.action")) {
            return false;
        }
        Project project = context.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return false;
        }
        PsiMethod actionBuilderAddMethod = FieldMetaBuilderUtil.getActionBuilderAddMethod(project, module);
        PsiMethod actionBuilderActionMethod = FieldMetaBuilderUtil.getActionBuilderActionMethod(project, module);
        PsiMethod actionDescriptionBuilderAddMethod = FieldMetaBuilderUtil.getActionDescriptionBuilderAddMethod(project, module);
        PsiMethod actionDescriptionBuilderActionMethod = FieldMetaBuilderUtil.getActionDescriptionBuilderActionMethod(project, module);
        if (actionBuilderActionMethod != null || actionBuilderAddMethod != null || actionDescriptionBuilderActionMethod != null || actionDescriptionBuilderAddMethod != null) {
            try {
                if (psiMethod instanceof ClsMethodImpl) {
                    ClsMethodImpl orig = (ClsMethodImpl)psiMethod;
                    PsiMethod decompiled = orig.getSourceMirrorMethod();
                    psiMethod = decompiled != null ? decompiled : psiMethod;
                }
            }
            catch (Exception e) {
                LOG.warn("Ups", (Throwable)e);
            }
            return psiMethod.equals(actionBuilderAddMethod) || psiMethod.equals(actionBuilderActionMethod) || psiMethod.equals(actionDescriptionBuilderAddMethod) || psiMethod.equals(actionDescriptionBuilderActionMethod);
        }
        return false;
    }

    @Nullable
    public static SimpleNamedElement getInjectedNameIdentifierOwner(@NotNull Project project, @NotNull Module module, @Nullable PsiElement name) {
        List injectedPsiFiles;
        if (project == null) {
            SimpleLangToPlatformActionInjector.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SimpleLangToPlatformActionInjector.$$$reportNull$$$0(1);
        }
        SimpleNamedElement injectedName = null;
        if (name instanceof PsiLanguageInjectionHost && (injectedPsiFiles = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles(name)) != null && !injectedPsiFiles.isEmpty()) {
            injectedName = (SimpleNamedElement)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)((Pair)injectedPsiFiles.get(0)).getFirst()), SimpleNamedElement.class);
        }
        return injectedName;
    }

    public Injection getInjection(@NotNull PsiElement context) {
        if (context == null) {
            SimpleLangToPlatformActionInjector.$$$reportNull$$$0(2);
        }
        if (SimpleLangToPlatformActionInjector.isActionNamedElement(context)) {
            return new SimpleInjection((Language)SimpleLanguage.INSTANCE, "", "", null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/injection/SimpleLangToPlatformActionInjector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjectedNameIdentifierOwner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInjection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

