/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.javaToMetaRefs.widgetName.reference;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.javaToMetaRefs.widgetName.reference.JavaWidgetNameReferenceContributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaWidgetNameReferenceProvider
extends PsiReferenceProvider {
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            JavaWidgetNameReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaWidgetNameReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PsiLiteral)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!JavaWidgetNameReferenceContributor.Holder.JAVA_WIDGET_NAME_REF_PATTERN.accepts((Object)element)) {
            return PsiReference.EMPTY_ARRAY;
        }
        String originalText = element.getText();
        String value = originalText.replace("\"", "");
        Project project = element.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Pair<Optional<? extends PsiNamedElement>, List<JWidget.WidgetLookupItem>> pair = JWidget.getLinkAndAutocompletionByWidgetName(value, project, module);
        List<LookupElement> collect = ((List)pair.getSecond()).stream().filter(Objects::nonNull).filter(e -> e.injectedNamedElement.getElement() != null && ((PsiNamedElement)e.injectedNamedElement.getElement()).getName() != null).map(e -> {
            ArrayList<String> lookupStrings = new ArrayList<String>();
            lookupStrings.add(((PsiNamedElement)e.injectedNamedElement.getElement()).getName());
            if (e.title != null) {
                lookupStrings.add(e.title);
            }
            return LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)e.injectedNamedElement.getElement())).withIcon(AllIcons.FileTypes.Json).withTypeText(e.getLookupText()).withLookupStrings(lookupStrings);
        }).collect(Collectors.toList());
        ArrayList<ReferenceLink> refs = new ArrayList<ReferenceLink>();
        refs.add(new ReferenceLink(element, new TextRange(1, value.length() + 1), ((Optional)pair.getFirst()).orElse(null), collect));
        return (PsiReference[])ContainerUtil.toArray(refs, PsiReference[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/javaToMetaRefs/widgetName/reference/JavaWidgetNameReferenceProvider";
        objectArray[2] = "getReferencesByElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ReferenceLink
    extends PsiReferenceBase<PsiElement> {
        final PsiElement resolve;
        final List<LookupElement> variants;

        public ReferenceLink(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @Nullable PsiElement resolve, @NotNull List<LookupElement> variants) {
            if (element == null) {
                ReferenceLink.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                ReferenceLink.$$$reportNull$$$0(1);
            }
            if (variants == null) {
                ReferenceLink.$$$reportNull$$$0(2);
            }
            super(element, rangeInElement, true);
            this.resolve = resolve;
            this.variants = variants;
        }

        @Nullable
        public PsiElement resolve() {
            return this.resolve;
        }

        public Object[] getVariants() {
            return this.variants.toArray();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variants";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/javaToMetaRefs/widgetName/reference/JavaWidgetNameReferenceProvider$ReferenceLink";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

