/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.move;

import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.refactoring.JavaRefactoringFactory;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesProcessor;
import com.intellij.util.Processor;
import org.cxbox.intellij.community.common.Cache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DtoRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        PsiClass dtoClass;
        if (element instanceof PsiClass && this.isDtoClass(dtoClass = (PsiClass)element)) {
            final String originalQualifiedName = dtoClass.getQualifiedName();
            return new RefactoringElementAdapter(){
                private String oldDtoQualifiedName;
                {
                    this.oldDtoQualifiedName = originalQualifiedName;
                }

                protected void elementRenamedOrMoved(PsiElement newElement) {
                    PsiClass movedDto;
                    PsiClass generatedDto;
                    if (newElement instanceof PsiClass && (generatedDto = DtoRefactoringListenerProvider.this.findGeneratedDtoClass(movedDto = (PsiClass)newElement, this.oldDtoQualifiedName)) != null) {
                        DtoRefactoringListenerProvider.this.moveGeneratedDtoToSamePackage(generatedDto, movedDto, this.oldDtoQualifiedName);
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement psiElement, @NotNull String oldQualifiedName) {
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (oldQualifiedName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    try {
                        PsiDirectory oldSourcesDir;
                        Project project = psiElement.getProject();
                        String oldPackage = DtoRefactoringListenerProvider.this.extractPackage(oldQualifiedName);
                        String generatedClassName = DtoRefactoringListenerProvider.this.extractClassName(oldQualifiedName) + "_";
                        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                        if (module == null) {
                            return;
                        }
                        PsiClass generatedDto = JavaPsiFacade.getInstance((Project)project).findClass(DtoRefactoringListenerProvider.this.extractPackage(psiElement instanceof PsiClass ? ((PsiClass)psiElement).getQualifiedName() : oldQualifiedName) + "." + generatedClassName, GlobalSearchScope.projectScope((Project)project));
                        if (generatedDto != null && (oldSourcesDir = DtoRefactoringListenerProvider.this.findOrCreateGeneratedSourcesDirectory(module, oldPackage)) != null) {
                            JavaRefactoringFactory refactoringFactory = JavaRefactoringFactory.getInstance((Project)project);
                            MoveDestination moveDestination = refactoringFactory.createSourceFolderPreservingMoveDestination(oldPackage);
                            new MoveClassesOrPackagesProcessor(project, new PsiElement[]{generatedDto}, moveDestination, false, false, null).run();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "psiElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray[1] = "org/cxbox/intellij/community/move/DtoRefactoringListenerProvider$1";
                    objectArray[2] = "undoElementMovedOrRenamed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return null;
    }

    private boolean isDtoClass(PsiClass psiClass) {
        return psiClass.isInheritor(Cache.getDataResponseDTOClass(psiClass.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)), true);
    }

    private PsiClass findGeneratedDtoClass(PsiClass originalDto, String originalQualifiedName) {
        Project project = originalDto.getProject();
        String generatedClassName = originalDto.getName() + "_";
        if (originalQualifiedName == null) {
            return null;
        }
        String generatedQualifiedName = originalQualifiedName.replaceFirst(originalDto.getName() + "$", generatedClassName);
        return (PsiClass)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)project).findClass(generatedQualifiedName, GlobalSearchScope.projectScope((Project)project)));
    }

    private void moveGeneratedDtoToSamePackage(PsiClass generatedDto, PsiClass movedOriginalDto, String originalQualifiedName) {
        try {
            Project project = generatedDto.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)movedOriginalDto);
            if (module == null) {
                return;
            }
            PsiPackage targetPackage = (PsiPackage)ReadAction.compute(() -> JavaDirectoryService.getInstance().getPackage(movedOriginalDto.getContainingFile().getContainingDirectory()));
            if (targetPackage == null) {
                return;
            }
            JavaRefactoringFactory refactoringFactory = JavaRefactoringFactory.getInstance((Project)project);
            MoveDestination moveDestination = refactoringFactory.createSourceFolderPreservingMoveDestination(targetPackage.getQualifiedName());
            new MoveClassesOrPackagesProcessor(project, new PsiElement[]{generatedDto}, moveDestination, false, false, null).run();
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                this.updateImportsForGeneratedDto(generatedDto, project);
                this.updateReferencesToGeneratedDto(generatedDto, originalQualifiedName, project);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateImportsForGeneratedDto(PsiClass generatedDto, Project project) {
        try {
            PsiFile generatedFile = generatedDto.getContainingFile();
            if (generatedFile != null) {
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)generatedFile);
                JavaCodeStyleManager.getInstance((Project)project).optimizeImports(generatedFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateReferencesToGeneratedDto(PsiClass generatedDto, final String oldQualifiedName, final Project project) {
        try {
            final String newQualifiedName = generatedDto.getQualifiedName();
            if (newQualifiedName == null || oldQualifiedName.equals(newQualifiedName)) {
                return;
            }
            PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
            GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
            searchHelper.processAllFilesWithWord(oldQualifiedName + "_", scope, (Processor)new Processor<PsiFile>(){

                public boolean process(PsiFile psiFile) {
                    if (psiFile instanceof PsiJavaFile) {
                        DtoRefactoringListenerProvider.this.updateOldImportsInFile((PsiJavaFile)psiFile, oldQualifiedName, newQualifiedName, project);
                    }
                    return true;
                }
            }, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateOldImportsInFile(PsiJavaFile psiFile, String oldQualifiedName, String newQualifiedName, Project project) {
        try {
            PsiImportList importList = psiFile.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStatement importStatement : importList.getImportStatements()) {
                if (importStatement.getQualifiedName() == null || !importStatement.getQualifiedName().equals(oldQualifiedName)) continue;
                importStatement.delete();
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                PsiImportStatement newImport = elementFactory.createImportStatement(JavaPsiFacade.getInstance((Project)project).findClass(newQualifiedName, GlobalSearchScope.projectScope((Project)project)));
                if (newImport == null) continue;
                importList.add((PsiElement)newImport);
            }
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)psiFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String extractPackage(String qualifiedName) {
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return "";
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        return lastDot > 0 ? qualifiedName.substring(0, lastDot) : "";
    }

    private String extractClassName(String qualifiedName) {
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return "";
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        return lastDot > 0 ? qualifiedName.substring(lastDot + 1) : qualifiedName;
    }

    private PsiDirectory findOrCreateGeneratedSourcesDirectory(Module module, String packageQualifiedName) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] sourceRoots = rootManager.getSourceRoots(true);
        VirtualFile generatedSourcesRoot = null;
        for (VirtualFile root : sourceRoots) {
            if (!root.getPath().contains("generated-sources")) continue;
            generatedSourcesRoot = root;
            break;
        }
        if (generatedSourcesRoot == null && sourceRoots.length > 0) {
            generatedSourcesRoot = sourceRoots[0];
        }
        if (generatedSourcesRoot == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        PsiDirectory baseDir = psiManager.findDirectory(generatedSourcesRoot);
        if (baseDir == null) {
            return null;
        }
        return PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)packageQualifiedName, (PsiDirectory)baseDir, (boolean)false);
    }
}

