/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RunLineMarkerInfo
extends MergeableLineMarkerInfo<PsiElement> {
    private final DefaultActionGroup myActionGroup;
    private final AnAction mySingleAction;

    public RunLineMarkerInfo(PsiElement element, Icon icon, Function<? super PsiElement, String> tooltipProvider, DefaultActionGroup actionGroup) {
        super(element, element.getTextRange(), icon, tooltipProvider, null, GutterIconRenderer.Alignment.LEFT, () -> (String)tooltipProvider.fun((Object)element));
        this.myActionGroup = actionGroup;
        this.mySingleAction = this.myActionGroup.getChildrenCount() == 1 ? this.myActionGroup.getChildActionsOrStubs()[0] : null;
    }

    @NotNull
    public static LineMarkerInfo<PsiElement> createLineMarker(@NotNull PsiElement element, @NotNull Icon icon, @NotNull List<RunLineMarkerContributor.Info> infos) {
        if (element == null) {
            RunLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            RunLineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (infos == null) {
            RunLineMarkerInfo.$$$reportNull$$$0(2);
        }
        Comparator COMPARATOR = (a, b) -> {
            if (b.shouldReplace(a)) {
                return 1;
            }
            if (a.shouldReplace(b)) {
                return -1;
            }
            return 0;
        };
        if (infos.size() > 1) {
            infos.sort(COMPARATOR);
            RunLineMarkerContributor.Info first = infos.get(0);
            infos.removeIf(info -> info != first && first.shouldReplace(info));
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (RunLineMarkerContributor.Info info2 : infos) {
            for (AnAction action : info2.actions) {
                actionGroup.add((AnAction)(action instanceof Separator ? action : new LineMarkerActionWrapper(element, action)));
            }
            if (info2 == infos.get(infos.size() - 1)) continue;
            actionGroup.add((AnAction)new Separator());
        }
        Function tooltipProvider = element1 -> {
            StringBuilder tooltip = new StringBuilder();
            for (RunLineMarkerContributor.Info info : infos) {
                String string;
                if (info.tooltipProvider == null || (string = (String)info.tooltipProvider.apply(element1)) == null) continue;
                if (tooltip.length() != 0) {
                    tooltip.append("\n");
                }
                tooltip.append(string);
            }
            return tooltip.length() == 0 ? null : RunLineMarkerInfo.appendShortcut(tooltip.toString());
        };
        return new RunLineMarkerInfo(element, icon, (Function<? super PsiElement, String>)tooltipProvider, actionGroup);
    }

    private static String appendShortcut(String tooltip) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return tooltip;
        }
        String shortcutText = "inside widgets array press Ctl+J or start typing";
        @NotNull String shortcutColor = ColorUtil.toHex((Color)JBUI.CurrentTheme.Tooltip.shortcutForeground());
        return XmlStringUtil.wrapInHtml((CharSequence)(XmlStringUtil.escapeString((String)tooltip).replaceAll("\n", "<br>") + "&nbsp;&nbsp;<font color='#" + shortcutColor + "'>" + XmlStringUtil.escapeString((String)shortcutText) + "</font>"));
    }

    public GutterIconRenderer createGutterRenderer() {
        return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

            public AnAction getClickAction() {
                return RunLineMarkerInfo.this.mySingleAction;
            }

            public boolean isNavigateAction() {
                return true;
            }

            public ActionGroup getPopupMenuActions() {
                return RunLineMarkerInfo.this.myActionGroup;
            }
        };
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = MarkupEditorFilterFactory.createIsNotDiffFilter();
        if (markupEditorFilter == null) {
            RunLineMarkerInfo.$$$reportNull$$$0(3);
        }
        return markupEditorFilter;
    }

    public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
        if (info == null) {
            RunLineMarkerInfo.$$$reportNull$$$0(4);
        }
        return info instanceof RunLineMarkerInfo && info.getIcon() == this.getIcon();
    }

    public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        if (infos == null) {
            RunLineMarkerInfo.$$$reportNull$$$0(5);
        }
        return this.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/lineMarker/RunLineMarkerInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/lineMarker/RunLineMarkerInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canMergeWith";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommonIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

