/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.searchParameter.reference.commentEntityName;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInspection.reference.PsiMemberReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jgoodies.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullyNameInCommentReferenceProvider
extends PsiReferenceProvider {
    public static String getFullyNameFromComment(@NotNull PsiComment comment) {
        if (comment == null) {
            FullyNameInCommentReferenceProvider.$$$reportNull$$$0(0);
        }
        return comment.getText().replaceAll("//@entity:", "").trim();
    }

    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
        PsiComment psiComment;
        if (psiElement == null) {
            FullyNameInCommentReferenceProvider.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            FullyNameInCommentReferenceProvider.$$$reportNull$$$0(2);
        }
        if (!(psiElement instanceof PsiComment) || !(psiComment = (PsiComment)psiElement).getText().trim().startsWith("//@entity:")) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        List<Object> refs = new ArrayList();
        String fullyEntityName = FullyNameInCommentReferenceProvider.getFullyNameFromComment(psiComment);
        if (!Strings.isBlank((String)fullyEntityName)) {
            refs = this.refs(fullyEntityName, psiComment);
        }
        return refs.isEmpty() ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(refs, PsiReference[]::new);
    }

    @NotNull
    private List<PsiReference> refs(@NotNull String fullyEntityName, @NotNull PsiComment comment) {
        if (fullyEntityName == null) {
            FullyNameInCommentReferenceProvider.$$$reportNull$$$0(3);
        }
        if (comment == null) {
            FullyNameInCommentReferenceProvider.$$$reportNull$$$0(4);
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        Project project = comment.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass psiClass = javaPsiFacade.findClass(fullyEntityName, GlobalSearchScope.allScope((Project)project));
        if (psiClass == null) {
            ArrayList<PsiReference> arrayList = refs;
            if (arrayList == null) {
                FullyNameInCommentReferenceProvider.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        refs.add((PsiReference)new ReferenceLinkCommentEntity(comment, new TextRange(comment.getStartOffsetInParent() + "//@entity:".length(), comment.getStartOffsetInParent() + comment.getTextLength()), (PsiElement)psiClass, List.of(JavaLookupElementBuilder.forClass((PsiClass)psiClass))));
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            FullyNameInCommentReferenceProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyEntityName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/java/searchParameter/reference/commentEntityName/FullyNameInCommentReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/java/searchParameter/reference/commentEntityName/FullyNameInCommentReferenceProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "refs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullyNameFromComment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refs";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    public static class ReferenceLinkCommentEntity
    extends PsiReferenceBase<PsiComment>
    implements PsiMemberReference {
        final PsiElement resolve;
        final List variants;

        public ReferenceLinkCommentEntity(@NotNull PsiComment element, @NotNull TextRange rangeInElement, @Nullable PsiElement resolve, @NotNull List variants) {
            if (element == null) {
                ReferenceLinkCommentEntity.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                ReferenceLinkCommentEntity.$$$reportNull$$$0(1);
            }
            if (variants == null) {
                ReferenceLinkCommentEntity.$$$reportNull$$$0(2);
            }
            super((PsiElement)element, rangeInElement, false);
            this.resolve = resolve;
            this.variants = variants;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                ReferenceLinkCommentEntity.$$$reportNull$$$0(3);
            }
            return element;
        }

        @Nullable
        public PsiElement resolve() {
            return this.resolve;
        }

        public Object[] getVariants() {
            return this.variants.toArray();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variants";
                    break;
                }
            }
            objectArray2[1] = "org/cxbox/intellij/community/java/searchParameter/reference/commentEntityName/FullyNameInCommentReferenceProvider$ReferenceLinkCommentEntity";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "bindToElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

