/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import java.util.Arrays;
import java.util.List;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DtoConstructorUtil {
    @Nullable
    public static PsiClass getDtoBeanMapper(@Nullable PsiClass dtoPsiClass, @Nullable PsiClass entityPsiClass) {
        PsiClass dtoMapper = null;
        if (dtoPsiClass != null && entityPsiClass != null) {
            Project project = dtoPsiClass.getProject();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)dtoPsiClass);
            if (module == null) {
                throw new IllegalStateException();
            }
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
            PsiClass dtoBaseClass = javaPsiFacade.findClass(Cache.getPlatformRootPackageWithoutDot(project, module) + ".api.data.dto.DataResponseDTO", scp);
            PsiClass entityBaseClass = javaPsiFacade.findClass(Cache.getPlatformRootPackageWithoutDot(project, module) + ".model.core.entity.BaseEntity", scp);
            PsiClass dtoMapperParent = javaPsiFacade.findClass(Cache.getPlatformRootPackageWithoutDot(project, module) + ".core.dto.mapper.DtoConstructor", scp);
            if (dtoMapperParent != null) {
                dtoMapper = (PsiClass)ClassInheritorsSearch.search((PsiClass)dtoMapperParent).filtering(e -> {
                    PsiMethod[] constructors = e.getConstructors();
                    PsiMethod constructor = constructors[0];
                    PsiClass constructorDtoClass = JavaUtil.getConstructorSuperCallParamWithTypeInheritedFromClass(constructor, dtoBaseClass);
                    PsiClass constructorEntityClass = JavaUtil.getConstructorSuperCallParamWithTypeInheritedFromClass(constructor, entityBaseClass);
                    return constructorDtoClass != null && constructorDtoClass.equals(dtoPsiClass) && constructorEntityClass != null && constructorEntityClass.equals(entityPsiClass);
                }).findFirst();
            }
        }
        return dtoMapper;
    }

    public static void addEntityToDtoFieldMapping(@NotNull Project project, List<String> mapperBuilderPutLines, PsiClass dtoMapper) {
        if (project == null) {
            DtoConstructorUtil.$$$reportNull$$$0(0);
        }
        if (!mapperBuilderPutLines.isEmpty()) {
            PsiMethod buildValueSuppliersMethod = JavaUtil.getMethodThatOverridesParentMethod(dtoMapper, "buildValueSuppliers");
            PsiCodeBlock body = buildValueSuppliersMethod.getBody();
            PsiStatement[] statements = body.getStatements();
            PsiStatement buildStatement = Arrays.stream(statements).filter(smt -> StringUtil.endsWith((CharSequence)smt.getText(), (CharSequence)".build();")).findFirst().orElse(null);
            mapperBuilderPutLines.forEach(mapperBuilderPutLine -> {
                String replaced = buildStatement.getText().replace(".build();", mapperBuilderPutLine + ".build();");
                PsiElementFactory entityElementFactory = JavaPsiFacade.getElementFactory((Project)project);
                PsiStatement statement = entityElementFactory.createStatementFromText(replaced, null);
                PsiElement newStatement = buildStatement.replace((PsiElement)statement);
                JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)project);
                instance.shortenClassReferences(newStatement);
            });
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)buildValueSuppliersMethod.getContainingFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/cxbox/intellij/community/common/util/DtoConstructorUtil", "addEntityToDtoFieldMapping"));
    }
}

