/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.tool;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.cxbox.intellij.community.icons.PlatformIcons;
import org.cxbox.intellij.community.tool.RunPlatformInspectionsAction;
import org.jetbrains.annotations.NotNull;

public class PlatformToolsWindowFactory
implements ToolWindowFactory {
    public static <T> T build(T component, Consumer<T> configurator) {
        configurator.accept(component);
        return component;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            PlatformToolsWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            PlatformToolsWindowFactory.$$$reportNull$$$0(1);
        }
        JButton runButton = PlatformToolsWindowFactory.build(new JButton("Run Inspections"), e -> {
            e.setAlignmentX(0.0f);
            e.addActionListener(ev -> new RunPlatformInspectionsAction().analyze(project));
            e.setToolTipText("Run platform specific inspections only. Much faster than `default` profile in Code -> Inspect Code");
        });
        JBPanel buttonPanel = PlatformToolsWindowFactory.build(new JBPanel(), e -> {
            e.setLayout((LayoutManager)new BoxLayout((Container)e, 0));
            e.setAlignmentX(0.0f);
            e.add((Component)runButton);
            e.add(Box.createRigidArea(new Dimension(10, 0)));
            JBLabel label = PlatformToolsWindowFactory.build(new JBLabel("Validate meta, etc"), l -> {
                l.setFont((Font)JBFont.label());
                l.setComponentStyle(UIUtil.ComponentStyle.SMALL);
                l.setFontColor(UIUtil.FontColor.NORMAL);
                l.setForeground((Color)JBColor.gray);
            });
            e.add((Component)label);
        });
        JBPanel panel = PlatformToolsWindowFactory.build(new JBPanel(), e -> {
            e.setLayout((LayoutManager)new BoxLayout((Container)e, 1));
            e.setBorder((Border)JBUI.Borders.empty((int)0, (int)15, (int)10, (int)0));
            e.add((Component)buttonPanel);
        });
        PlatformToolsWindowFactory.build(toolWindow, e -> {
            e.getComponent().add((Component)panel);
            e.setTitle("Platform Tools");
            e.setStripeTitle("Platform Tools");
        });
        Content content = ContentFactory.getInstance().createContent((JComponent)panel, "", true);
        content.setIcon(PlatformIcons.platformTools);
        ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addContent(content);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "toolWindow";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/tool/PlatformToolsWindowFactory";
        objectArray[2] = "createToolWindowContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

