/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.layout;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public final class LayoutFieldKeyNotDefinedOrHiddenInFieldsInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "LayoutFieldKeyNotDefinedOrHiddenInFieldsInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            LayoutFieldKeyNotDefinedOrHiddenInFieldsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            LayoutFieldKeyNotDefinedOrHiddenInFieldsInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith("widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        List<Triple<String, JsonObject, JsonArray>> widgetFields = JWidget.getWidgetFields(widgetFile);
        ArrayList problemLayoutFieldKeys = new ArrayList();
        JWidget.visitWidgetLayoutFieldKeys(JsonFacade.getTopLevelObject(widgetFile), (Consumer<JsonStringLiteral>)((Consumer)fieldKey -> {
            String filedKeyValue = JsonFacade.safeGetValueAsString((PsiElement)fieldKey);
            Boolean isFieldHiddenOrNotExists = widgetFields.stream().filter(pair -> Objects.equals(pair.getLeft(), filedKeyValue)).map(pair -> JWidget.isFieldHidden((JsonObject)pair.getMiddle()) && !JWidget.isFieldMultifield((JsonObject)pair.getMiddle())).findFirst().orElse(Boolean.TRUE);
            if (Boolean.TRUE.equals(isFieldHiddenOrNotExists)) {
                problemLayoutFieldKeys.add(fieldKey);
            }
        }));
        SmartList descriptors = new SmartList();
        problemLayoutFieldKeys.stream().filter(Objects::nonNull).forEach(arg_0 -> LayoutFieldKeyNotDefinedOrHiddenInFieldsInspection.lambda$checkFile$3((List)descriptors, manager, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void lambda$checkFile$3(List descriptors, InspectionManager manager, JsonStringLiteral layoutFieldKey) {
        descriptors.add(manager.createProblemDescriptor((PsiElement)layoutFieldKey, new TextRange(1, layoutFieldKey.getValue().length() + 1), "Field referenced in layout is not defined in field tag. Delete", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix()}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/wigdet/options/layout/LayoutFieldKeyNotDefinedOrHiddenInFieldsInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        private Fix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Delete undefined or hidden in fields tag field key";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Undefined";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElement element = descriptor.getPsiElement();
            JsonObject fieldKeyObject = JsonFacade.getParentOfType(element, JsonObject.class);
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
                if (fieldKeyObject != null) {
                    JsonObject prevFieldKeyObject = (JsonObject)JsonFacade.getPrevSiblingOfType((PsiElement)fieldKeyObject, JWidget.LAYOUT_ROWS_COLS.arrayItemType());
                    JsonArray layoutRowsCols = JsonFacade.getParentOfType((PsiElement)fieldKeyObject, JWidget.LAYOUT_ROWS_COLS.valueType());
                    if (layoutRowsCols != null && prevFieldKeyObject != null && prevFieldKeyObject.getNextSibling() != fieldKeyObject) {
                        layoutRowsCols.deleteChildRange(prevFieldKeyObject.getNextSibling(), (PsiElement)fieldKeyObject);
                    } else {
                        fieldKeyObject.delete();
                    }
                }
                QuickFixUtils.safeDoPostponedOperationsIfPossible(project, element);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/options/layout/LayoutFieldKeyNotDefinedOrHiddenInFieldsInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

