/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.icons.AllIcons;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.ConstructorUtils;
import org.cxbox.intellij.community.common.util.CreClassesFqn;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.MinPackageUtils;
import org.cxbox.intellij.community.common.util.ModuleLibUtils;
import org.cxbox.intellij.community.common.util.PsiCommentUtil;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.common.ResponseServiceType;
import org.cxbox.intellij.community.wigdet.bc.service.utils.RepositoryUtils;
import org.cxbox.intellij.community.wigdet.fields.AwareResponseServiceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResponseServiceUtils {
    public static final String VERSION_AWARE_RESPONSE_SERVICE = ".core.crudma.impl.VersionAwareResponseService";
    public static final String ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE = ".core.crudma.impl.AnySourceVersionAwareResponseService";
    public static final ElementPattern<PsiClass> ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE_PATTERN = StandardPatterns.or((ElementPattern[])((ElementPattern[])Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> PsiJavaPatterns.psiClass().inheritorOf(false, prefix + ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE)).toArray(ElementPattern[]::new)));
    public static final ElementPattern<PsiClass> VERSION_AWARE_RESPONSE_SERVICE_PATTERN = StandardPatterns.or((ElementPattern[])((ElementPattern[])Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> PsiJavaPatterns.psiClass().inheritorOf(false, prefix + VERSION_AWARE_RESPONSE_SERVICE)).toArray(ElementPattern[]::new)));

    @NotNull
    public static Optional<PsiClass> getEntityByDto(@Nullable PsiClass dto, @NotNull Module module) {
        List<ResponseServiceData> allResponseServiceData;
        Optional<PsiClass> entityFromService;
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(0);
        }
        if (dto == null || dto.getQualifiedName() == null) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                ResponseServiceUtils.$$$reportNull$$$0(1);
            }
            return optional;
        }
        if (PsiCommentUtil.containCommitWithPrefixes((PsiElement)dto, List.of("@entity:", "//@entity:"))) {
            PsiClass entityClass;
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)dto.getProject());
            String comment = PsiCommentUtil.getCommentWithPrefixesAndFullyName((PsiElement)dto, List.of("@entity:", "//@entity:"));
            if (comment != null && (entityClass = javaPsiFacade.findClass(comment, GlobalSearchScope.allScope((Project)dto.getProject()))) != null) {
                Optional<PsiClass> optional = Optional.of(entityClass);
                if (optional == null) {
                    ResponseServiceUtils.$$$reportNull$$$0(2);
                }
                return optional;
            }
        }
        Optional<PsiClass> optional = (entityFromService = (allResponseServiceData = ResponseServiceUtils.getAllResponseServiceData(module.getProject(), module)).stream().filter(e -> e.responseServiceDtoPsiClass.getManager().areElementsEquivalent((PsiElement)e.responseServiceDtoPsiClass, (PsiElement)dto) || e.responseServiceDtoPsiClass.isInheritorDeep(dto, null)).map(ResponseServiceData::responseServiceEntityPsiClass).findFirst()).isEmpty() ? ResponseServiceUtils.getEnittyFromConstructor(dto) : entityFromService;
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(3);
        }
        return optional;
    }

    public static boolean hasVersionAwareResponseServiceConstructorWithoutParam(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(4);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(5);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        return Cache.getAllPossiblePlatformRootPackageWithoutDot().stream().map(prefix -> prefix + VERSION_AWARE_RESPONSE_SERVICE).map(versionAwareResponseServiceFqn -> javaPsiFacade.findClass(versionAwareResponseServiceFqn, SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, project))).filter(Objects::nonNull).map(PsiClass::getConstructors).flatMap(Arrays::stream).filter(Objects::nonNull).anyMatch(constructor -> constructor.getParameters().length == 0);
    }

    @NotNull
    public static List<ResponseServiceData> getAllResponseServiceData(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(6);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(7);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        List list = (List)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result(ResponseServiceUtils.getAllResponseServiceDataNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public static ResponseServiceData getResponseServiceDataByClassName(@NotNull Project project, @NotNull Module module, String serviceClassName, @NotNull Predicate<ResponseServiceData> className) {
        Set collect;
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(9);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(10);
        }
        if (className == null) {
            ResponseServiceUtils.$$$reportNull$$$0(11);
        }
        if ((collect = ResponseServiceUtils.getAllResponseServiceData(project, module).stream().filter(className).collect(Collectors.toSet())).size() > 1) {
            throw new PlatformValidationException("Find more than one class with name " + serviceClassName, null, project);
        }
        return collect.iterator().hasNext() ? (ResponseServiceData)collect.iterator().next() : null;
    }

    @Nullable
    public static ResponseServiceData getResponseServiceDataByBc(@NotNull Project project, @NotNull Module module, PsiEnumConstant bc) {
        PsiClass bcServiceClass;
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(12);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(13);
        }
        if ((bcServiceClass = EnumBcUtil.getBcServiceClass(bc, project, module)) != null) {
            return ResponseServiceUtils.getResponseServiceData(bcServiceClass, module);
        }
        return null;
    }

    @NotNull
    private static List<ResponseServiceData> getAllResponseServiceDataNoCache(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(14);
        }
        ArrayList<PsiClass> all = new ArrayList<PsiClass>();
        all.addAll(ResponseServiceUtils.getAllAnySourceResponseServiceImplementationsNoCache(module));
        all.addAll(ResponseServiceUtils.getAllResponseServiceImplementationsNoCache(module));
        List<ResponseServiceData> list = all.stream().map(e -> ResponseServiceUtils.getResponseServiceData(e, module)).filter(Objects::nonNull).toList();
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    public static ResponseServiceData getResponseServiceData(@NotNull PsiClass responseServicePsiClass, @NotNull Module module) {
        PsiClass responseServiceEntityPsiClass;
        if (responseServicePsiClass == null) {
            ResponseServiceUtils.$$$reportNull$$$0(16);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(17);
        }
        if ((responseServiceEntityPsiClass = (PsiClass)ResponseServiceUtils.getVersionAwareResponseServiceEntity(responseServicePsiClass, module.getProject(), module).orElse(null)) == null && (responseServiceEntityPsiClass = (PsiClass)ResponseServiceUtils.getAnySourceResponseServiceEntity(responseServicePsiClass, module.getProject(), module).orElse(null)) == null) {
            return null;
        }
        PsiClass responseServiceDtoPsiClass = ResponseServiceUtils.getResponseServiceDto(responseServicePsiClass, module.getProject(), module).orElse(null);
        if (responseServiceDtoPsiClass == null) {
            return null;
        }
        return new ResponseServiceData(responseServicePsiClass, responseServiceEntityPsiClass, responseServiceEntityPsiClass.getQualifiedName(), responseServiceDtoPsiClass, responseServiceDtoPsiClass.getQualifiedName());
    }

    @NotNull
    private static List<PsiClass> getAllResponseServiceImplementationsNoCache(@NotNull Module module) {
        PsiClass responseServiceInterface;
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(18);
        }
        if ((responseServiceInterface = ResponseServiceUtils.getResponseServiceInterface(module)) == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ResponseServiceUtils.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<PsiClass> list = JavaUtil.getInterfaceImplementaions(responseServiceInterface).stream().filter(PsiClass.class::isInstance).map(PsiClass.class::cast).toList();
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private static List<PsiClass> getAllAnySourceResponseServiceImplementationsNoCache(@NotNull Module module) {
        PsiClass responseServiceInterface;
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(21);
        }
        if ((responseServiceInterface = ResponseServiceUtils.getAnySourceResponseServiceInterface(module)) == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                ResponseServiceUtils.$$$reportNull$$$0(22);
            }
            return list;
        }
        List<PsiClass> list = JavaUtil.getInterfaceImplementaions(responseServiceInterface).stream().filter(PsiClass.class::isInstance).map(PsiClass.class::cast).toList();
        if (list == null) {
            ResponseServiceUtils.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Nullable
    public static PsiClass getResponseServiceInterface(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(24);
        }
        return Cache.findPsiClassByName(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".core.service.ResponseService", module);
    }

    @Nullable
    public static PsiClass getAnySourceBaseDAOInterface(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(25);
        }
        return Cache.findPsiClassByName(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".core.dao.AnySourceBaseDAO", module);
    }

    @Nullable
    public static PsiClass getAnySourceResponseServiceInterface(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(26);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)module.getProject());
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)ResponseServiceUtils.getAnySourceResponseServiceInterfaceWithoutCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    @Nullable
    private static PsiClass getAnySourceResponseServiceInterfaceWithoutCache(@NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(27);
        }
        return Cache.findPsiClassByName(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".core.service.AnySourceResponseService", module);
    }

    @Nullable
    public static PsiMethod getActions(PsiClass psiClass, @NotNull Module module) {
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(28);
        }
        PsiMethod result = null;
        if (psiClass != null) {
            PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
            String methodName = "getActions";
            if (bcEnumServiceImplClass != null) {
                result = JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
            }
        }
        return result;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceMetaBuilder(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(29);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(30);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + ".core.service.rowmeta.FieldMetaBuilder";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getMeta");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(31);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceMetaBuilderFromFieldOrConstructor(PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(32);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(33);
        }
        if (bcEnumServiceClass == null) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                ResponseServiceUtils.$$$reportNull$$$0(34);
            }
            return optional;
        }
        Optional<PsiClass> meta = ResponseServiceUtils.getMetaBuilderFromField(bcEnumServiceClass);
        if (meta.isEmpty()) {
            meta = ResponseServiceUtils.getMetaFromConstructorParam(bcEnumServiceClass);
        }
        Optional<PsiClass> optional = meta;
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(35);
        }
        return optional;
    }

    private static Optional<PsiClass> getMetaFromConstructorParam(PsiClass bcEnumServiceClass) {
        PsiMethod[] constructors;
        Optional<PsiClass> meta = Optional.empty();
        PsiClass versionAwareClass = bcEnumServiceClass;
        int maxLength = 10;
        for (int count = 0; count < maxLength || !ModuleLibUtils.isFromProjectSources(versionAwareClass); ++count) {
            PsiClass superClass = versionAwareClass.getSuperClass();
            if (superClass == null) break;
            versionAwareClass = superClass;
        }
        for (PsiMethod constructor : constructors = bcEnumServiceClass.getConstructors()) {
            PsiClassObjectAccessExpression classObjExpr;
            PsiType type;
            PsiExpression metaBuilderExpr;
            PsiExpression[] args;
            PsiMethodCallExpression methodCall;
            PsiExpressionStatement exprStmt;
            PsiExpression expr;
            PsiStatement psiStatement;
            PsiStatement[] statements;
            PsiCodeBlock body = constructor.getBody();
            if (body == null || (statements = body.getStatements()).length <= 0 || !((psiStatement = statements[0]) instanceof PsiExpressionStatement) || !((expr = (exprStmt = (PsiExpressionStatement)psiStatement).getExpression()) instanceof PsiMethodCallExpression) || !"super".equals((methodCall = (PsiMethodCallExpression)expr).getMethodExpression().getReferenceName()) || (args = methodCall.getArgumentList().getExpressions()).length < 4 || !((metaBuilderExpr = args[3]) instanceof PsiClassObjectAccessExpression) || !((type = (classObjExpr = (PsiClassObjectAccessExpression)metaBuilderExpr).getOperand().getType()) instanceof PsiClassType)) continue;
            PsiClassType classType = (PsiClassType)type;
            PsiClass metaBuilderClass = classType.resolve();
            meta = Optional.ofNullable(metaBuilderClass);
            break;
        }
        return meta;
    }

    @NotNull
    private static Optional<PsiClass> getMetaBuilderFromField(PsiClass bcEnumServiceClass) {
        Optional<PsiClass> meta;
        Optional<PsiClass> optional = meta = Arrays.stream(bcEnumServiceClass.getFields()).filter(f -> f.getNameIdentifier().getText().equals("meta")).map(PsiField::getType).filter(PsiClassType.class::isInstance).map(pt -> (PsiClassType)pt).filter(pct -> pct.getParameters().length == 1 && PsiTypesUtil.getPsiClass((PsiType)pct.getParameters()[0]) != null).findFirst().map(pct -> PsiTypesUtil.getPsiClass((PsiType)pct.getParameters()[0]));
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(36);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getAnySourceResponseServiceMetaBuilder(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(37);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(38);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + ".core.service.rowmeta.FieldMetaBuilder";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getMeta");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(39);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceDto(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(40);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(41);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.DATA_RESPONSE_DTO_FQN_WITHOUT_PLATFORM.getValue();
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getTypeOfDTO");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(42);
        }
        return optional;
    }

    @Nullable
    public static PsiClass getResponseAwareServiceEntity(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(43);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(44);
        }
        if (bcEnumServiceClass == null) {
            return null;
        }
        if (ResponseServiceUtils.isVersionAwareResponseService(bcEnumServiceClass, project, module)) {
            return ResponseServiceUtils.getVersionAwareResponseServiceEntity(bcEnumServiceClass, project, module).orElse(null);
        }
        if (ResponseServiceUtils.isAnySourceVersionAwareResponseService(bcEnumServiceClass, project, module)) {
            return ResponseServiceUtils.getAnySourceResponseServiceEntity(bcEnumServiceClass, project, module).orElse(null);
        }
        return null;
    }

    @NotNull
    public static Optional<PsiClass> getVersionAwareResponseServiceEntity(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(45);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(46);
        }
        String returnGenericBaseClassFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.BASE_ENTITY_FQN_WITHOUT_PLATFORM.getValue();
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, "getTypeOfEntity");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(47);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getAnySourceResponseServiceEntity(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(48);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(49);
        }
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, "java.io.Serializable", "getTypeOfEntity");
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(50);
        }
        return optional;
    }

    public static boolean isAnySourceResponseServiceImplFromServiceClass(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(51);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(52);
        }
        PsiClass anySourceResponseServiceInterface = ResponseServiceUtils.getAnySourceResponseServiceInterface(module);
        return bcEnumServiceClass != null && anySourceResponseServiceInterface != null && bcEnumServiceClass.isInheritor(anySourceResponseServiceInterface, true);
    }

    public static boolean isVersionAwareResponseServiceImplFromServiceClass(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(53);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(54);
        }
        PsiClass versionAwareServiceClass = Cache.getVersionAwareServiceClass(project, module);
        return bcEnumServiceClass != null && versionAwareServiceClass != null && bcEnumServiceClass.isInheritor(versionAwareServiceClass, true);
    }

    public static Optional<PsiClass> getAnySourceResponseServiceDAO(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        PsiClass anySourceResponseServiceInterface;
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(55);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(56);
        }
        if ((anySourceResponseServiceInterface = ResponseServiceUtils.getAnySourceResponseServiceInterface(module)) != null && bcEnumServiceClass != null && bcEnumServiceClass.isInheritor(anySourceResponseServiceInterface, true)) {
            PsiClass dao = JavaUtil.getPsiClassFromConstructorOrFieldOrGetter(bcEnumServiceClass, ".core.dao.AnySourceBaseDAO", "dao");
            return Optional.ofNullable(dao);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<PsiClass> getEnittyFromConstructor(@Nullable PsiClass dto) {
        PsiMethod[] constructors = dto.getConstructors();
        List<PsiMethod> constrictorsWithOneParameter = Arrays.stream(constructors).filter(constructor -> constructor.getParameters().length == 1).toList();
        if (constrictorsWithOneParameter.isEmpty()) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                ResponseServiceUtils.$$$reportNull$$$0(57);
            }
            return optional;
        }
        Optional<PsiClass> optional = constrictorsWithOneParameter.stream().map(constructor -> {
            PsiClassType psiClassType;
            PsiClass entity;
            JvmType type = constructors[0].getParameters()[0].getType();
            if (type instanceof PsiClassType && (entity = (psiClassType = (PsiClassType)type).resolve()) != null) {
                return entity;
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(58);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getResponseServiceSuggestionField(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(59);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(60);
        }
        String returnGenericBaseClassFQN = "java.io.Serializable";
        String methodName = "getTypeOfEntity";
        Optional<PsiClass> optional = JavaUtil.findDeepMethodByNameAndReturnTypeFirstGenericArgumentIsDeepInheritorOf(bcEnumServiceClass, project, returnGenericBaseClassFQN, methodName);
        if (optional == null) {
            ResponseServiceUtils.$$$reportNull$$$0(61);
        }
        return optional;
    }

    public static boolean isVersionAwareResponseService(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(62);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(63);
        }
        return bcEnumServiceClass != null && ResponseServiceUtils.hasSuperClassDeep(bcEnumServiceClass, Cache.getVersionAwareServiceClass(project, module).getQualifiedName());
    }

    public static boolean isVersionAwareResponseService(PsiEnumConstant psiEnumConstant, @NotNull Project project, @NotNull Module module) throws PlatformValidationException {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(64);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(65);
        }
        if (psiEnumConstant == null) {
            throw new PlatformValidationException("Bc is null.", null, new IllegalStateException("Bc is null. "), project, MessageType.INFO, AllIcons.General.Warning);
        }
        ResponseServiceData parentResponseServiceData = ResponseServiceUtils.getResponseServiceDataByBc(project, module, psiEnumConstant);
        if (parentResponseServiceData == null) {
            throw new PlatformValidationException("Cannot get type by bc <a href=\"1\">" + psiEnumConstant.getName() + "<a>.", JavaUtil.getNavigatableElement((PsiElement)psiEnumConstant), new IllegalStateException("Cannot get type by bc " + psiEnumConstant.getName()), project, MessageType.INFO, AllIcons.General.Warning);
        }
        return ResponseServiceUtils.isVersionAwareResponseService(parentResponseServiceData.responseServicePsiClass(), project, module);
    }

    public static boolean isAnySourceVersionAwareResponseService(@Nullable PsiEnumConstant psiEnumConstant, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(66);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(67);
        }
        if (psiEnumConstant == null) {
            throw new PlatformValidationException("Bc is null.", null, new IllegalStateException("Bc is null. "), project, MessageType.INFO, AllIcons.General.Warning);
        }
        ResponseServiceData parentResponseServiceData = ResponseServiceUtils.getResponseServiceDataByBc(project, module, psiEnumConstant);
        if (parentResponseServiceData == null) {
            throw new PlatformValidationException("Cannot get type by bc <a href=\"1\">" + psiEnumConstant.getName() + "<a>.", JavaUtil.getNavigatableElement((PsiElement)psiEnumConstant), new IllegalStateException("Cannot get type by bc " + psiEnumConstant.getName()), project, MessageType.INFO, AllIcons.General.Warning);
        }
        return ResponseServiceUtils.isAnySourceVersionAwareResponseService(parentResponseServiceData.responseServicePsiClass(), project, module);
    }

    public static boolean isAnySourceVersionAwareResponseService(@Nullable PsiClass bcEnumServiceClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(68);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(69);
        }
        if (Cache.getAnySourceServiceClass(project, module) == null) {
            return false;
        }
        return bcEnumServiceClass != null && ResponseServiceUtils.hasSuperClassDeep(bcEnumServiceClass, Cache.getAnySourceServiceClass(project, module).getQualifiedName());
    }

    public static boolean isMetaAvailableSort(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(70);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(71);
        }
        if (Cache.getFieldsCommonMeta(project, module) == null) {
            return false;
        }
        return Arrays.stream(Cache.getFieldsCommonMeta(project, module).getAllMethods()).anyMatch(m -> "enableSort".equals(m.getName()));
    }

    public static boolean isDtoInheritsDataResponseDTOResponse(@Nullable PsiClass dtoClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(72);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(73);
        }
        return dtoClass != null && ResponseServiceUtils.hasSuperClassDeep(dtoClass, Cache.getDataResponseDTOClass(project, module).getQualifiedName());
    }

    public static boolean isEntityInheritsBaseEntity(@Nullable PsiClass entityClass, @NotNull Project project, @NotNull Module module) {
        if (project == null) {
            ResponseServiceUtils.$$$reportNull$$$0(74);
        }
        if (module == null) {
            ResponseServiceUtils.$$$reportNull$$$0(75);
        }
        return entityClass != null && ResponseServiceUtils.hasSuperClassDeep(entityClass, Cache.getBaseEntityClass(project, module).getQualifiedName());
    }

    private static boolean hasSuperClassDeep(PsiClass bcEnumServiceClass, String superClassFQN) {
        return InheritanceUtil.isInheritor((PsiClass)bcEnumServiceClass, (String)superClassFQN);
    }

    @Nullable
    public static PsiClass getDtoByName(Project project, Module module, String dtoClzName) {
        PsiClass ancestorClz = Cache.getDataResponseDTOClass(project, module);
        if (ancestorClz == null || dtoClzName == null) {
            return null;
        }
        Query query = ClassInheritorsSearch.search((PsiClass)ancestorClz, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)true);
        for (PsiClass psiClass : query) {
            if (!dtoClzName.equals(psiClass.getName())) continue;
            return psiClass;
        }
        return null;
    }

    public static Map<PsiClass, String> findMinCommonPackageHolder(Collection<PsiClass> classes, PsiClass baseClass, PsiElement psiElement, Collection<PsiClass> enumsBcHolder, ResponseServiceData responseServiceData) {
        JavaPsiFacade jpf = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        HashMap mapMinPackageHolderBc = new HashMap();
        Project project = psiElement.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        Set<PsiPackage> pckgs = classes.stream().filter(psc -> psc.getQualifiedName() != null).filter(ModuleLibUtils::isFromProjectSources).filter(f -> !JavaUtil.isAbstractOrInterfaceClass(f)).map(PsiElement::getContainingFile).filter(PsiJavaFile.class::isInstance).map(PsiJavaFile.class::cast).map(PsiJavaFile::getPackageName).map(arg_0 -> ((JavaPsiFacade)jpf).findPackage(arg_0)).collect(Collectors.toSet());
        String packageDefault = MinPackageUtils.minCommonPackage(baseClass, pckgs, psiElement, cc -> cc.isInheritor(baseClass, true), false);
        mapMinPackageHolderBc.put(null, packageDefault);
        PsiPackage psiPackage = Optional.ofNullable(responseServiceData).map(rsd -> rsd.responseServicePsiClass).filter(ModuleLibUtils::isFromProjectSources).filter(f -> !JavaUtil.isAbstractOrInterfaceClass(f)).map(PsiElement::getContainingFile).filter(PsiJavaFile.class::isInstance).map(PsiJavaFile.class::cast).map(PsiJavaFile::getPackageName).map(arg_0 -> ((JavaPsiFacade)jpf).findPackage(arg_0)).orElse(null);
        enumsBcHolder.forEach(ebh -> {
            List<PsiEnumConstant> enumConstants = EnumBcUtil.getPsiConstantFromEnumBcIdentifier(ebh, psiElement.getProject(), module);
            if (!enumConstants.isEmpty()) {
                Set<PsiPackage> allBcService = enumConstants.stream().map(enumConstant -> ResponseServiceUtils.getResponseServiceDataByBc(project, module, enumConstant)).map(rsd -> ResponseServiceUtils.extractClassFromResponseServiceData(project, module, baseClass, rsd)).filter(Objects::nonNull).filter(ModuleLibUtils::isFromProjectSources).filter(f -> !JavaUtil.isAbstractOrInterfaceClass(f)).map(PsiElement::getContainingFile).filter(PsiJavaFile.class::isInstance).map(PsiJavaFile.class::cast).filter(psiJavaFile -> Arrays.stream(psiJavaFile.getClasses()).anyMatch(cls -> cls.isInheritor(baseClass, true))).map(PsiJavaFile::getPackageName).map(arg_0 -> ((JavaPsiFacade)jpf).findPackage(arg_0)).collect(Collectors.toSet());
                mapMinPackageHolderBc.put(ebh, MinPackageUtils.minCommonPackage(baseClass, allBcService, psiElement, cc -> cc.isInheritor(baseClass, true), false));
            }
        });
        return mapMinPackageHolderBc.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void visitSubPackage(PsiPackage psiPackage, Set<PsiClass> classes, Map<PsiPackage, Set<PsiClass>> packageSetMap, Predicate<PsiClass> predicate) {
        PsiPackage[] subPackages;
        classes.addAll(Arrays.stream(psiPackage.getClasses(GlobalSearchScope.projectScope((Project)psiPackage.getProject()))).filter(predicate).collect(Collectors.toSet()));
        for (PsiPackage subPackage : subPackages = psiPackage.getSubPackages()) {
            if (!packageSetMap.containsKey(subPackage)) {
                ResponseServiceUtils.visitSubPackage(subPackage, classes, packageSetMap, predicate);
                continue;
            }
            classes.addAll((Collection<PsiClass>)packageSetMap.get(subPackage));
        }
    }

    public static String findTargetPackage(Module module) {
        List main = (List)ReadAction.compute(() -> {
            ArrayList<PsiMethod> mainMethods = new ArrayList<PsiMethod>();
            GlobalSearchScope allScope = GlobalSearchScope.projectScope((Project)module.getProject());
            Set candidates = Arrays.stream(PsiShortNamesCache.getInstance((Project)module.getProject()).getMethodsByName("main", allScope)).filter(m -> m.getContainingClass() != null && ModuleLibUtils.isFromProjectSources(m.getContainingClass())).collect(Collectors.toSet());
            for (PsiMethod method : candidates) {
                Module moduleMain;
                boolean isPlatformModule;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !(isPlatformModule = ModuleLibUtils.moduleContainsLibraryMatching(moduleMain = ModuleUtilCore.findModuleForPsiElement((PsiElement)method), List.of("tesler.core", "cxbox.core"))) || moduleMain == null || ResponseServiceUtils.getAllResponseServiceData(moduleMain.getProject(), moduleMain).isEmpty()) continue;
                mainMethods.add(method);
            }
            return mainMethods;
        });
        return Optional.ofNullable(JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("")).map(PsiPackage::getQualifiedName).map(rootPackage -> main.stream().map(PsiElement::getContainingFile).filter(PsiJavaFile.class::isInstance).map(PsiJavaFile.class::cast).map(PsiJavaFile::getPackageName).min(Comparator.comparingInt(p -> ResponseServiceUtils.distanceLevenshtein(rootPackage, p))).orElse(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".example")).orElse(main.stream().map(PsiElement::getContainingFile).filter(PsiJavaFile.class::isInstance).map(PsiJavaFile.class::cast).map(PsiJavaFile::getPackageName).min(Comparator.comparingInt(p -> p.split("\\.").length)).orElse(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".example"));
    }

    private static int distanceLevenshtein(String rootPackage, String b) {
        int i;
        int[][] dp = new int[rootPackage.length() + 1][b.length() + 1];
        for (i = 0; i <= rootPackage.length(); ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= b.length(); ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= rootPackage.length(); ++i) {
            for (int j = 1; j <= b.length(); ++j) {
                dp[i][j] = Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + (rootPackage.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1));
            }
        }
        return dp[rootPackage.length()][b.length()];
    }

    public static String findRepoPackage(Module module, String targetPackage) {
        return RepositoryUtils.getAllRepository(module).stream().map(PsiElement::getContainingFile).filter(PsiJavaFile.class::isInstance).map(PsiJavaFile.class::cast).map(PsiJavaFile::getPackageName).min(Comparator.comparingInt(p -> p.split("\\.").length)).orElse(targetPackage);
    }

    public static Map<ResponseServiceType, List<ResponseServiceData>> collectServicesToMapByResponseType(Module module) {
        return ResponseServiceUtils.getAllResponseServiceData(module.getProject(), module).stream().filter(Objects::nonNull).filter(rsd -> Optional.of(rsd).map(ResponseServiceData::responseServicePsiClass).map(ModuleLibUtils::isFromProjectSources).orElse(false)).collect(Collectors.groupingBy(rsd -> ResponseServiceUtils.isVersionAwareResponseService(rsd.responseServicePsiClass(), module.getProject(), module) ? ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE : ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE));
    }

    public static boolean isNewApi(Project project, Module module) {
        return ConstructorUtils.isHaveConstructorWithoutParameters(Cache.getVersionAwareServiceClass(project, module));
    }

    @Nullable
    public static AwareResponseServiceType getServiceTypeFromJsonWidgetFile(PsiFile file) {
        if (!(file instanceof JsonFile)) {
            return null;
        }
        JsonFile jsonFile = (JsonFile)file;
        String widgetBC = JWidget.getWidgetBC(jsonFile);
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)jsonFile);
        Project project = file.getProject();
        return EnumBcUtil.getEnumBc(widgetBC, project, module).map(c -> AwareResponseServiceType.getServiceTypeFromPsiConstant(c, project, module)).orElse(null);
    }

    public static PsiClass extractClassFromResponseServiceData(Project project, Module module, PsiClass baseClass, ResponseServiceData responseServiceData) {
        PsiClass baseEntityClass = Cache.getBaseEntityClass(project, module);
        PsiClass dataResponseDTOClass = Cache.getDataResponseDTOClass(project, module);
        PsiClass anySourceServiceClass = Cache.getAnySourceServiceClass(project, module);
        PsiClass awareServiceClass = Cache.getVersionAwareServiceClass(project, module);
        if (baseClass.equals(baseEntityClass)) {
            return responseServiceData.responseServiceEntityPsiClass;
        }
        if (baseClass.equals(dataResponseDTOClass)) {
            return responseServiceData.responseServiceDtoPsiClass;
        }
        if (baseClass.equals(anySourceServiceClass) || baseClass.equals(awareServiceClass)) {
            return responseServiceData.responseServicePsiClass;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 15, 19, 20, 22, 23, 31, 34, 35, 36, 39, 42, 47, 50, 57, 58, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 47: 
            case 50: 
            case 57: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 29: 
            case 32: 
            case 37: 
            case 40: 
            case 43: 
            case 45: 
            case 48: 
            case 51: 
            case 53: 
            case 55: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseServicePsiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityByDto";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResponseServiceData";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResponseServiceDataNoCache";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResponseServiceImplementationsNoCache";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnySourceResponseServiceImplementationsNoCache";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceMetaBuilder";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceMetaBuilderFromFieldOrConstructor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaBuilderFromField";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnySourceResponseServiceMetaBuilder";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceDto";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionAwareResponseServiceEntity";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnySourceResponseServiceEntity";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnittyFromConstructor";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getResponseServiceSuggestionField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEntityByDto";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 42: 
            case 47: 
            case 50: 
            case 57: 
            case 58: 
            case 61: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasVersionAwareResponseServiceConstructorWithoutParam";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllResponseServiceData";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceDataByClassName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceDataByBc";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllResponseServiceDataNoCache";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllResponseServiceImplementationsNoCache";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnySourceResponseServiceImplementationsNoCache";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceInterface";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceBaseDAOInterface";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceInterface";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceInterfaceWithoutCache";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceMetaBuilder";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceMetaBuilderFromFieldOrConstructor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceMetaBuilder";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceDto";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getResponseAwareServiceEntity";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getVersionAwareResponseServiceEntity";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceEntity";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isAnySourceResponseServiceImplFromServiceClass";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isVersionAwareResponseServiceImplFromServiceClass";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAnySourceResponseServiceDAO";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getResponseServiceSuggestionField";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isVersionAwareResponseService";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isAnySourceVersionAwareResponseService";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isMetaAvailableSort";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isDtoInheritsDataResponseDTOResponse";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isEntityInheritsBaseEntity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 15, 19, 20, 22, 23, 31, 34, 35, 36, 39, 42, 47, 50, 57, 58, 61 -> new IllegalStateException(string);
        };
    }

    public record ResponseServiceData(@NotNull PsiClass responseServicePsiClass, PsiClass responseServiceEntityPsiClass, String responseServiceEntityFQN, PsiClass responseServiceDtoPsiClass, String responseServiceDtoFQN) {
        @NotNull
        private final PsiClass responseServicePsiClass;

        public ResponseServiceData(@NotNull PsiClass responseServicePsiClass, PsiClass responseServiceEntityPsiClass, String responseServiceEntityFQN, PsiClass responseServiceDtoPsiClass, String responseServiceDtoFQN) {
            if (responseServicePsiClass == null) {
                ResponseServiceData.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public PsiClass responseServicePsiClass() {
            PsiClass psiClass = this.responseServicePsiClass;
            if (psiClass == null) {
                ResponseServiceData.$$$reportNull$$$0(1);
            }
            return psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "responseServicePsiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils$ResponseServiceData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/common/util/ResponseServiceUtils$ResponseServiceData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "responseServicePsiClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

