/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.actionBuilder;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.concurrent.atomic.AtomicReference;
import org.cxbox.intellij.community.java.actionBuilder.DeprecatedNewActionUsage;
import org.cxbox.intellij.community.java.actionBuilder.DeprecatedNewActionUsageConfig;
import org.jetbrains.annotations.NotNull;

public class DeprecatedNewActionUsageQuickFix
implements LocalQuickFix {
    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length());
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return "Refactor to action builder to recommended lambda based syntax";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        String builderWithRefactoredAction;
        PsiMethodCallExpression addCall;
        if (project == null) {
            DeprecatedNewActionUsageQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            DeprecatedNewActionUsageQuickFix.$$$reportNull$$$0(1);
        }
        if ((addCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getEndElement(), PsiMethodCallExpression.class)) == null) {
            throw new IncorrectOperationException();
        }
        Pair<PsiMethodCallExpression, String> newAction = DeprecatedNewActionUsage.findCreateActionStartCall(addCall);
        String newActionName = (String)newAction.getSecond();
        PsiMethodCallExpression newActionCall = (PsiMethodCallExpression)newAction.getFirst();
        if (newActionCall == null) {
            throw new IncorrectOperationException();
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)addCall, (PsiElement)newActionCall);
        if (commonParent == null) {
            throw new IncorrectOperationException();
        }
        PsiFile file = addCall.getContainingFile();
        String builderToAddIncluding = file.getText().subSequence(commonParent.getTextRange().getStartOffset(), addCall.getTextRange().getEndOffset()).toString();
        String builderToNewActionIncluding = file.getText().subSequence(commonParent.getTextRange().getStartOffset(), newActionCall.getTextRange().getEndOffset()).toString();
        String newActionExcludingToAddIncluding = file.getText().subSequence(newActionCall.getTextRange().getEndOffset(), addCall.getTextRange().getEndOffset()).toString();
        String builderToItsEndIncluding = file.getText().subSequence(commonParent.getTextRange().getStartOffset(), commonParent.getTextRange().getEndOffset()).toString();
        DeprecatedNewActionUsageConfig.Fix fix = DeprecatedNewActionUsageConfig.DEPRECATED_CREATE_ACTION_START_METHODS.stream().filter(e -> e.name().equals(newActionName)).findFirst().orElseThrow();
        if (!fix.keepMethodInChain()) {
            String head = DeprecatedNewActionUsageQuickFix.replaceLast(builderToNewActionIncluding, "." + newActionName + "()", "");
            String dotAndChainText = DeprecatedNewActionUsageQuickFix.replaceLast(newActionExcludingToAddIncluding, ".add()", "");
            String body = !dotAndChainText.isBlank() ? fix.replacement().apply(dotAndChainText) : fix.emptyChainReplacement();
            String tail = builderToItsEndIncluding.replace(builderToAddIncluding, "");
            builderWithRefactoredAction = head + body + tail;
        } else {
            String builderToNewActionExcluding = file.getText().subSequence(commonParent.getTextRange().getStartOffset(), newActionCall.getMethodExpression().getQualifierExpression().getTextRange().getEndOffset()).toString();
            String newActionIncludingToAddIncluding = file.getText().subSequence(newActionCall.getMethodExpression().getQualifierExpression().getTextRange().getEndOffset(), addCall.getTextRange().getEndOffset()).toString();
            String head = builderToNewActionExcluding;
            String dotAndChainText = DeprecatedNewActionUsageQuickFix.replaceLast(newActionIncludingToAddIncluding, ".add()", "");
            String body = !dotAndChainText.isBlank() ? "\n" + fix.replacement().apply(dotAndChainText) : fix.emptyChainReplacement();
            String tail = builderToItsEndIncluding.replace(builderToAddIncluding, "");
            builderWithRefactoredAction = head + body + tail;
        }
        AtomicReference newCommonParent = new AtomicReference();
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            newCommonParent.set(commonParent.replace((PsiElement)elementFactory.createExpressionFromText(builderWithRefactoredAction, commonParent)));
        });
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newCommonParent.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/java/actionBuilder/DeprecatedNewActionUsageQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

