/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.EnumBcUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.exception.InternalErrorPlatformException;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.service.TemplateProperties;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;
import org.cxbox.intellij.community.wigdet.fields.field.generator.common.TemplatesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BcServiceMethodUpdaterUtils {
    @Nullable
    public static PsiMethod findMethodGetSpecification(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            BcServiceMethodUpdaterUtils.$$$reportNull$$$0(0);
        }
        PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
        String methodName = "getSpecification";
        if (bcEnumServiceImplClass != null) {
            return JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodDoCreateEntity(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            BcServiceMethodUpdaterUtils.$$$reportNull$$$0(1);
        }
        PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
        String methodName = "doCreateEntity";
        if (bcEnumServiceImplClass != null) {
            return JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodGetList(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            BcServiceMethodUpdaterUtils.$$$reportNull$$$0(2);
        }
        PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
        String methodName = "getList";
        if (bcEnumServiceImplClass != null) {
            return JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodDoUpdate(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            BcServiceMethodUpdaterUtils.$$$reportNull$$$0(3);
        }
        PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
        String methodName = "doUpdateEntity";
        if (bcEnumServiceImplClass != null) {
            return JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBuildRowDependentMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            BcServiceMethodUpdaterUtils.$$$reportNull$$$0(4);
        }
        PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
        String methodName = "buildRowDependentMeta";
        if (bcEnumServiceImplClass != null) {
            return JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBuildIndependentMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            BcServiceMethodUpdaterUtils.$$$reportNull$$$0(5);
        }
        PsiClass bcEnumServiceImplClass = JavaUtil.getAnyImplementationIfInterfaceOrElseClass(psiClass);
        String methodName = "buildIndependentMeta";
        if (bcEnumServiceImplClass != null) {
            return JavaUtil.getMethodThatOverridesParentMethod(bcEnumServiceImplClass, methodName);
        }
        return null;
    }

    public static void updateGetSpecificationOnService(ElementGenerationContext context, Function<SpecificationUpdateData, PsiStatement> functionUpdating, Function<PsiClass, String> functionCreating) {
        PsiMethod psiMethod = BcServiceMethodUpdaterUtils.findMethodGetSpecification(context.elementBcData().serviceClz());
        boolean isParentBcVersionAware = Boolean.parseBoolean(context.properties().getProperty(TemplateProperties.PARENT_VERSION_AWARE_CLASS.name()));
        String fieldName = context.properties().getProperty(TemplateProperties.PARENT_ENTITY_NAME.name());
        String bcName = Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::bcEnum).map(PsiJvmMember::getContainingClass).map(PsiClass::getQualifiedName).orElse(null);
        if (psiMethod == null) {
            String apply = functionCreating.apply(context.elementBcData().entityClz());
            psiMethod = JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createMethodFromText(apply, (PsiElement)context.elementBcData().serviceClz());
            psiMethod = (PsiMethod)context.elementBcData().serviceClz().add((PsiElement)psiMethod);
        }
        SpecificationUpdateData prms = new SpecificationUpdateData(isParentBcVersionAware, context.elementBcData().entityClz().getQualifiedName(), fieldName, bcName);
        PsiStatement statement = functionUpdating.apply(prms);
        JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)context.module().getProject());
        BcServiceMethodUpdaterUtils.addStatementToMethod(context, psiMethod, statement);
        BcServiceMethodUpdaterUtils.addImport(Cache.getBaseEntityMetaModelClass(context.module().getProject(), context.module()), context.elementBcData().serviceClz());
        BcServiceMethodUpdaterUtils.addImport(context.elementBcData().entityClz().getQualifiedName() + "_", context.elementBcData().serviceClz());
        instance.shortenClassReferences((PsiElement)statement);
        instance.shortenClassReferences((PsiElement)psiMethod);
    }

    public static void updateGetListInAnySourceDAO(ElementGenerationContext context, Function<String, List<PsiElement>> functionUpdate) {
        PsiMethod psiMethod = BcServiceMethodUpdaterUtils.findMethodGetList(context.elementBcData().daoClz());
        if (psiMethod == null || psiMethod.getBody() == null) {
            return;
        }
        List<PsiElement> statements = functionUpdate.apply(context.elementBcData().bcEnumName());
        if (statements == null || statements.isEmpty()) {
            return;
        }
        PsiCodeBlock methodBody = psiMethod.getBody();
        PsiJavaToken lBrace = psiMethod.getBody().getLBrace();
        if (lBrace == null || methodBody == null) {
            return;
        }
        PsiElement anchor = methodBody.addAfter(PsiParserFacade.getInstance((Project)context.module().getProject()).createWhiteSpaceFromText("\n"), (PsiElement)lBrace);
        for (PsiElement statement : statements) {
            anchor = psiMethod.getBody().addAfter(statement, anchor);
        }
    }

    public static void updateDoCreateEntityInService(ElementGenerationContext context) {
        PsiClass serviceClass = context.elementBcData().serviceClz();
        PsiMethod psiMethod = BcServiceMethodUpdaterUtils.findMethodDoCreateEntity(serviceClass);
        if (psiMethod == null) {
            throw new PlatformValidationException("Cannot find doCreateEntity method on class: <a href= \"1\">" + serviceClass.getName() + "<a>.", JavaUtil.getNavigatableElement((PsiElement)serviceClass), new IllegalStateException("Cannot find doCreateEntity method on class" + serviceClass.getName()), serviceClass.getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        PsiParameterList parameterList = psiMethod.getParameterList();
        PsiClass jpaDaoClass = Cache.getJpaDAOClass(context.module());
        String entity = null;
        if (parameterList.getParametersCount() <= 0) {
            throw new PlatformValidationException("Generation not available", null, new IllegalStateException("Parameter list in doCreateEntity is empty"), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        PsiParameter firstParam = parameterList.getParameters()[0];
        entity = firstParam.getName();
        boolean isRepo = Boolean.parseBoolean(context.properties().getProperty(TemplateProperties.IS_PERSISTENCE_REPOSITORY.name()));
        String fieldName = null;
        PsiClass parentRepoClz = context.elementBcData().parentRepoClz();
        boolean isParentVa = ResponseServiceUtils.isVersionAwareResponseService(context.elementBcData().parentBcEnum(), context.module().getProject(), context.module());
        boolean isOldApi = Boolean.parseBoolean(context.properties().getProperty(TemplateProperties.OLD_API.name()));
        if (isParentVa) {
            if (isRepo) {
                List<PsiField> psiFields = BcServiceMethodUpdaterUtils.findFieldsBySuper(parentRepoClz.getQualifiedName(), serviceClass);
                if (psiFields.isEmpty()) {
                    String repoName = Optional.of(parentRepoClz).map(PsiNamedElement::getName).orElseThrow(() -> new PlatformValidationException("Cannot get name class " + parentRepoClz.getName() + "<a>.", JavaUtil.getNavigatableElement((PsiElement)parentRepoClz), new IllegalStateException("Cannot get name class" + parentRepoClz.getName()), serviceClass.getProject(), MessageType.INFO, AllIcons.General.Warning));
                    fieldName = JavaUtil.deCapitalizeFirstLetter(repoName);
                    BcServiceMethodUpdaterUtils.addPrivateFinalFieldToClass(parentRepoClz, fieldName, serviceClass, context.module(), isOldApi, serviceClass.getConstructors());
                } else {
                    fieldName = psiFields.iterator().next().getName();
                }
            } else {
                List<PsiField> psiFields = BcServiceMethodUpdaterUtils.findFieldsBySuper(jpaDaoClass.getQualifiedName(), serviceClass);
                if (psiFields.isEmpty()) {
                    fieldName = "jpaDao";
                    BcServiceMethodUpdaterUtils.addPrivateFinalFieldToClass(jpaDaoClass, fieldName, serviceClass, context.module(), isOldApi, serviceClass.getConstructors());
                } else {
                    fieldName = psiFields.iterator().next().getName();
                }
            }
            BcServiceMethodUpdaterUtils.addImport(jpaDaoClass, serviceClass);
        }
        PsiClass bcHolderClass = EnumBcUtil.getProjectBcHolderClass(context.module()).iterator().next();
        PsiStatement statementFromText = JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createStatementFromText(TemplatesKt.doCreateUpdateWithParentEntity(entity, isRepo, isParentVa, fieldName, Optional.ofNullable(context.elementBcData().parentEntityClz()).map(PsiQualifiedNamedElement::getName).orElseThrow(() -> new PlatformValidationException("Cannot find entity on bc <a href=\"1\">" + String.valueOf(context.elementBcData().parentBcEnum()) + "</a>.", JavaUtil.getNavigatableElement((PsiElement)context.elementBcData().parentBcEnum()), new IllegalStateException("Cannot find entity on bc" + String.valueOf(context.elementBcData().parentBcEnum()) + "."), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning)), Optional.ofNullable(context.elementBcData().parentEntityClz()).map(PsiClass::getQualifiedName).orElse(null), bcHolderClass.getQualifiedName() + "." + context.elementBcData().bcEnumName()), null);
        BcServiceMethodUpdaterUtils.addStatementToMethod(context, psiMethod, statementFromText);
    }

    public static void updateDTO(ElementGenerationContext context) {
        PsiClass optionalClass;
        PsiClass dtoClass = context.elementBcData().dtoClz();
        boolean isVersionAware = ResponseServiceUtils.isVersionAwareResponseService(context.elementBcData().parentBcEnum(), context.module().getProject(), context.module());
        PsiMethod[] constructorWithParameters = (PsiMethod[])Arrays.stream(dtoClass.getConstructors()).filter(m -> !m.getParameterList().isEmpty()).filter(m -> BcServiceMethodUpdaterUtils.isConstructorWithNeedParameters(m, 1, Map.of(0, List.of(Cache.getBaseEntityClass(context.module().getProject(), context.module()), Cache.getDataResponseDTOClass(context.module().getProject(), context.module()))))).toArray(PsiMethod[]::new);
        String fieldName = context.properties().getProperty(TemplateProperties.PARENT_ENTITY_NAME.name()) + "Id";
        String getter = context.properties().getProperty(TemplateProperties.GETTER_PARENT_ENTITY.name());
        BcServiceMethodUpdaterUtils.addPrivateFieldToClass(JavaPsiFacade.getInstance((Project)context.module().getProject()).findClass("java.lang.String", GlobalSearchScope.allScope((Project)context.module().getProject())), fieldName, dtoClass, context.module(), false, constructorWithParameters);
        String name = Optional.of(constructorWithParameters[0]).map(PsiMethod::getParameterList).map(pl -> pl.getParameter(0)).map(PsiParameter::getName).orElseThrow(() -> new PlatformValidationException("Cannot find constructor with signature (T entity), where T extends BaseEntity or DataResponseDTO in <a href=\"\">" + dtoClass.getName() + "</a>.", JavaUtil.getNavigatableElement((PsiElement)dtoClass), new IllegalStateException("Cannot find constructor(T entity), where T extends BaseEntity or DataResponseDTO in " + dtoClass.getName() + "."), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning));
        PsiStatement statement = JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createStatementFromText(TemplatesKt.doUpdateWithParentEntity(name, isVersionAware, fieldName, getter), null);
        BcServiceMethodUpdaterUtils.addStatementToMethodToEnd(context, constructorWithParameters[0], statement);
        if (isVersionAware) {
            BcServiceMethodUpdaterUtils.addImport(Cache.getBaseEntityClass(context.module().getProject(), context.module()), dtoClass);
        }
        if ((optionalClass = JavaPsiFacade.getInstance((Project)context.module().getProject()).findClass("java.util.Optional", GlobalSearchScope.allScope((Project)context.module().getProject()))) == null) {
            throw new InternalErrorPlatformException("Cannot find Optional class in project", null, new IllegalStateException("Cannot find Optional class in project"), context.module().getProject());
        }
        BcServiceMethodUpdaterUtils.addImport(optionalClass, dtoClass);
    }

    public static void updateDoUpdateInService(ElementGenerationContext context) {
        String repoField;
        if (ResponseServiceUtils.isAnySourceVersionAwareResponseService(context.elementBcData().serviceClz(), context.module().getProject(), context.module())) {
            return;
        }
        boolean isRepo = Boolean.parseBoolean(context.properties().getProperty(TemplateProperties.IS_PERSISTENCE_REPOSITORY.name()));
        boolean isParentVa = ResponseServiceUtils.isVersionAwareResponseService(context.elementBcData().parentBcEnum(), context.module().getProject(), context.module());
        boolean isOldApi = Boolean.parseBoolean(context.properties().getProperty(TemplateProperties.OLD_API.name()));
        PsiMethod methodDoUpdate = BcServiceMethodUpdaterUtils.findMethodDoUpdate(context.elementBcData().serviceClz());
        if (methodDoUpdate == null) {
            throw new PlatformValidationException("Cannot find doUpdateEntity in <a href\"1\">" + context.elementBcData().serviceClz().getName() + "</a>.", JavaUtil.getNavigatableElement((PsiElement)context.elementBcData().serviceClz()), new IllegalStateException("Cannot find doUpdateEntity in " + context.elementBcData().serviceClz().getName() + "."), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        if (methodDoUpdate.getParameterList().getParameter(1) == null || methodDoUpdate.getParameterList().getParameter(0) == null) {
            throw new PlatformValidationException("Cannot get parameters from doUpdateEntity in <a href\"1\">" + context.elementBcData().serviceClz().getName() + ".#" + methodDoUpdate.getName() + "</a>.", JavaUtil.getNavigatableElement((PsiElement)context.elementBcData().serviceClz()), new IllegalStateException("Cannot get parameters from doUpdateEntity in " + context.elementBcData().serviceClz().getName() + ".#" + methodDoUpdate.getName() + " ."), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        String paramNameData = Objects.requireNonNull(methodDoUpdate.getParameterList().getParameter(1)).getName();
        String paramNameEntity = Objects.requireNonNull(methodDoUpdate.getParameterList().getParameter(0)).getName();
        String fieldName = context.properties().getProperty(TemplateProperties.PARENT_ENTITY_NAME.name());
        String setterField = context.properties().getProperty(TemplateProperties.SETTER_PARENT_ENTITY.name());
        List<PsiField> jpaPsiFields = BcServiceMethodUpdaterUtils.findFieldsBySuper(Cache.getJpaDAOClass(context.module()).getQualifiedName(), context.elementBcData().serviceClz());
        String jpaDaoField = jpaPsiFields.isEmpty() ? "jpaDao" : jpaPsiFields.get(0).getName();
        ArrayList<PsiField> repoFields = new ArrayList<PsiField>();
        if (context.elementBcData().parentRepoClz() != null) {
            repoFields.addAll(BcServiceMethodUpdaterUtils.findFieldsBySuper(context.elementBcData().parentRepoClz().getQualifiedName(), context.elementBcData().serviceClz()).stream().filter(f -> context.elementBcData().parentRepoClz().equals((Object)PsiTypesUtil.getPsiClass((PsiType)f.getType()))).toList());
        }
        if (isParentVa) {
            String repoFieldName = repoFields.isEmpty() ? null : ((PsiField)repoFields.get(0)).getName();
            repoField = repoFields.isEmpty() && context.elementBcData().parentRepoClz() != null && context.elementBcData().parentRepoClz().getName() != null ? JavaUtil.deCapitalizeFirstLetter(context.elementBcData().parentRepoClz().getName()) : repoFieldName;
        } else {
            repoField = null;
        }
        PsiStatement statementFromText = JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createStatementFromText(TemplatesKt.bcCreationUpdateDoUpdate(isRepo, isParentVa, paramNameData, Optional.of(context).map(ElementGenerationContext::elementBcData).map(ElementGenerationContext.ElementBcData::dtoClz).map(PsiNamedElement::getName).orElseThrow(() -> new PlatformValidationException("Cannot find DTO class", null, new IllegalStateException("Cannot find dto class"), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning)), fieldName, paramNameEntity, setterField, repoField, Optional.of(context.elementBcData()).map(ElementGenerationContext.ElementBcData::parentEntityClz).map(PsiClass::getQualifiedName).orElseThrow(() -> new PlatformValidationException("Cannot find entity on bc <a href=\"1\">" + context.elementBcData().parentBcEnum().getName() + "</a>", JavaUtil.getNavigatableElement((PsiElement)context.elementBcData().parentBcEnum()), new IllegalStateException("Cannot find entity on bc <a href=\"1\">" + context.elementBcData().parentBcEnum().getName() + "</a>"), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning)), jpaDaoField), null);
        BcServiceMethodUpdaterUtils.addStatementToMethod(context, methodDoUpdate, statementFromText);
        if (isParentVa) {
            if (isRepo) {
                if (repoField != null && repoField.isEmpty()) {
                    BcServiceMethodUpdaterUtils.addPrivateFinalFieldToClass(context.elementBcData().parentRepoClz(), repoField, context.elementBcData().serviceClz(), context.module(), isOldApi, context.elementBcData().serviceClz().getConstructors());
                }
            } else if (jpaPsiFields.isEmpty()) {
                BcServiceMethodUpdaterUtils.addPrivateFinalFieldToClass(Cache.getJpaDAOClass(context.module()), jpaDaoField, context.elementBcData().serviceClz(), context.module(), isOldApi, context.elementBcData().serviceClz().getConstructors());
            }
        }
        BcServiceMethodUpdaterUtils.addImport(context.elementBcData().dtoClz().getQualifiedName() + "_", context.elementBcData().serviceClz());
    }

    public static void updateDependentAndIndependentOnMetaBuilder(ElementGenerationContext context) {
        PsiClass metaClz = context.elementBcData().metaClz();
        PsiClass dtoClz = context.elementBcData().dtoClz();
        String fieldName = JavaUtil.deCapitalizeFirstLetter(context.properties().getProperty(TemplateProperties.PARENT_ENTITY_NAME.name())) + "Id";
        PsiMethod dependentFieldMeta = BcServiceMethodUpdaterUtils.findMethodBuildRowDependentMeta(metaClz);
        PsiMethod inDependentFieldMeta = BcServiceMethodUpdaterUtils.findMethodBuildIndependentMeta(metaClz);
        if (dependentFieldMeta == null || inDependentFieldMeta == null) {
            Object name;
            Object object = name = dependentFieldMeta == null ? "dependentFieldMeta" : "";
            if (inDependentFieldMeta == null) {
                name = ((String)name).isBlank() ? (String)name + "inDependentFieldMeta" : (String)name + " and inDependentFieldMeta";
            }
            throw new PlatformValidationException("Cannot found on <a href=\"1\">" + String.valueOf(context.elementBcData().metaClz()) + "</a> method " + (String)name, JavaUtil.getNavigatableElement((PsiElement)context.elementBcData().parentBcEnum()), new IllegalStateException("Cannot find entity on bc <a href=\"1\">" + context.elementBcData().parentBcEnum().getName() + "</a>"), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        if (dependentFieldMeta.getParameterList().getParameter(0) == null) {
            throw new PlatformValidationException("Cannot get parameters on <a href=\"1\">" + context.elementBcData().metaClz().getName() + ".#dependentFieldMeta </a>.", JavaUtil.getNavigatableElement((PsiElement)dependentFieldMeta), new IllegalStateException("Cannot get parameters on " + context.elementBcData().metaClz().getName() + ".#dependentFieldMeta"), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        if (inDependentFieldMeta.getParameterList().getParameter(0) == null) {
            throw new PlatformValidationException("Cannot get parameters on <a href=\"1\">" + context.elementBcData().metaClz().getName() + ".#inDependentFieldMeta </a>.", JavaUtil.getNavigatableElement((PsiElement)inDependentFieldMeta), new IllegalStateException("Cannot get parameters on " + context.elementBcData().metaClz().getName() + ".#inDependentFieldMeta"), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        String fieldsDependentMeta = Objects.requireNonNull(dependentFieldMeta.getParameterList().getParameter(0)).getName();
        String fieldInDependentMeta = Objects.requireNonNull(inDependentFieldMeta.getParameterList().getParameter(0)).getName();
        PsiStatement enableFieldStatement = JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createStatementFromText(TemplatesKt.getFieldEnabledMeta(dtoClz.getQualifiedName(), fieldName, fieldsDependentMeta), null);
        PsiStatement filterFieldStatement = JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createStatementFromText(TemplatesKt.getFieldFilterMeta(dtoClz.getQualifiedName(), fieldName, fieldInDependentMeta), null);
        PsiStatement sortFieldStatement = JavaPsiFacade.getElementFactory((Project)context.module().getProject()).createStatementFromText(TemplatesKt.getFieldSortMeta(dtoClz.getQualifiedName(), fieldName, fieldInDependentMeta), null);
        BcServiceMethodUpdaterUtils.addStatementToMethodToEnd(context, dependentFieldMeta, enableFieldStatement);
        BcServiceMethodUpdaterUtils.addStatementToMethodToEnd(context, inDependentFieldMeta, filterFieldStatement);
        if (Boolean.parseBoolean(context.properties().getProperty(TemplateProperties.IS_META_SORT_ENABLED.name()))) {
            BcServiceMethodUpdaterUtils.addStatementToMethodToEnd(context, inDependentFieldMeta, sortFieldStatement);
        }
    }

    private static PsiField addPrivateFinalFieldToClass(PsiClass fieldClass, String fieldName, PsiClass parentClazz, Module module, Boolean addToConstructor, PsiMethod[] constructors) {
        PsiField psiField = BcServiceMethodUpdaterUtils.addFieldToClass(fieldClass, fieldName, parentClazz, module, addToConstructor, constructors, List.of(Pair.create((Object)"private", (Object)true), Pair.create((Object)"final", (Object)true)));
        BcServiceMethodUpdaterUtils.shortenClassReferences(module, (PsiElement)psiField);
        return psiField;
    }

    private static PsiField addPrivateFieldToClass(PsiClass fieldClass, String fieldName, PsiClass parentClazz, Module module, Boolean addToConstructor, PsiMethod[] constructors) {
        PsiField psiField = BcServiceMethodUpdaterUtils.addFieldToClass(fieldClass, fieldName, parentClazz, module, addToConstructor, constructors, List.of(Pair.create((Object)"private", (Object)true), Pair.create((Object)"final", (Object)false)));
        BcServiceMethodUpdaterUtils.shortenClassReferences(module, (PsiElement)psiField);
        return psiField;
    }

    private static PsiField addFieldToClass(PsiClass fieldClass, String fieldName, PsiClass parentClazz, Module module, Boolean addToConstructor, PsiMethod[] constructors, List<Pair<String, Boolean>> modifiers) {
        PsiField psiField = JavaPsiFacade.getElementFactory((Project)module.getProject()).createField(fieldName, (PsiType)JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(fieldClass));
        PsiModifierList modifierList = psiField.getModifierList();
        if (modifierList != null && modifierList.isWritable() && modifiers != null) {
            modifiers.forEach(m -> modifierList.setModifierProperty((String)m.first, ((Boolean)m.second).booleanValue()));
        }
        parentClazz.add((PsiElement)psiField);
        if (addToConstructor.booleanValue()) {
            if (constructors == null || constructors.length < 1) {
                throw new PlatformValidationException("Cannot find constructor on <a href=\"1\">" + parentClazz.getName() + "</a>", JavaUtil.getNavigatableElement((PsiElement)parentClazz), new IllegalStateException("Cannot find constructor " + parentClazz.getName()), parentClazz.getProject(), MessageType.INFO, AllIcons.General.Warning);
            }
            if (constructors.length > 1) {
                throw new PlatformValidationException("Find more than 1 constructor on <a href=\"1\">" + parentClazz.getName() + "</a>", JavaUtil.getNavigatableElement((PsiElement)parentClazz), new IllegalStateException("Find more than 1 on " + parentClazz.getName()), parentClazz.getProject(), MessageType.INFO, AllIcons.General.Warning);
            }
            PsiMethod constructor = constructors[0];
            PsiParameter parameter = JavaPsiFacade.getElementFactory((Project)module.getProject()).createParameter(fieldName, (PsiType)JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(fieldClass));
            constructor.getParameterList().add((PsiElement)parameter);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)module.getProject());
            PsiStatement assignment = factory.createStatementFromText("this." + fieldName + " = " + fieldName + ";", (PsiElement)constructor);
            if (constructor.getBody() != null) {
                constructor.getBody().add((PsiElement)assignment);
            }
            BcServiceMethodUpdaterUtils.shortenClassReferences(module, (PsiElement)assignment);
        }
        BcServiceMethodUpdaterUtils.addImport(fieldClass, parentClazz);
        return psiField;
    }

    private static boolean isConstructorWithNeedParameters(PsiMethod method, Integer count, Map<Integer, List<PsiClass>> classInheritors) {
        if (count != null && method.getParameters().length != count || count != null && !classInheritors.isEmpty() && classInheritors.size() != count.intValue()) {
            return false;
        }
        return classInheritors.entrySet().stream().allMatch(c -> {
            PsiClass psiClass = Optional.of(method.getParameterList()).map(pl -> pl.getParameter(((Integer)c.getKey()).intValue())).map(pp -> pp.getType()).map(pt -> PsiTypesUtil.getPsiClass((PsiType)pt)).orElse(null);
            if (psiClass == null) {
                return false;
            }
            return ((List)c.getValue()).stream().filter(Objects::nonNull).anyMatch(sc -> psiClass.isInheritor(sc, true));
        });
    }

    private static PsiElement addStatementToMethod(ElementGenerationContext context, PsiMethod method, PsiStatement statement) {
        PsiCodeBlock methodBody = method.getBody();
        PsiJavaToken lBrace = Optional.of(method).map(PsiMethod::getBody).map(PsiCodeBlock::getLBrace).orElse(null);
        if (lBrace == null || methodBody == null) {
            return null;
        }
        PsiElement anchor = methodBody.addAfter(PsiParserFacade.getInstance((Project)context.module().getProject()).createWhiteSpaceFromText("\n"), (PsiElement)lBrace);
        PsiElement psiElement = method.getBody().addAfter((PsiElement)statement, anchor);
        BcServiceMethodUpdaterUtils.shortenClassReferences(context.module(), psiElement);
        return psiElement;
    }

    private static PsiElement addStatementToMethodToEnd(ElementGenerationContext context, PsiMethod method, PsiStatement statement) {
        PsiCodeBlock methodBody = method.getBody();
        PsiJavaToken rBrace = Optional.of(method).map(PsiMethod::getBody).map(PsiCodeBlock::getRBrace).orElse(null);
        if (rBrace == null || methodBody == null) {
            return null;
        }
        PsiElement psiElement = method.getBody().addBefore((PsiElement)statement, (PsiElement)rBrace);
        BcServiceMethodUpdaterUtils.shortenClassReferences(context.module(), psiElement);
        return psiElement;
    }

    private static List<PsiField> findFieldsBySuper(String superClassFQN, PsiClass psiClass) {
        Module moduleClass = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiClass.getProject());
        if (moduleClass == null) {
            return Collections.emptyList();
        }
        PsiClass requiredSuper = facade.findClass(superClassFQN, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)moduleClass));
        ArrayList<PsiField> matchingFields = new ArrayList<PsiField>();
        for (PsiField field : psiClass.getAllFields()) {
            PsiClassType psiClassType;
            PsiClass fieldClass;
            PsiType type = field.getType();
            if (!(type instanceof PsiClassType) || (fieldClass = (psiClassType = (PsiClassType)type).resolve()) == null || requiredSuper == null || !fieldClass.isInheritor(requiredSuper, true) && !fieldClass.equals((Object)requiredSuper)) continue;
            matchingFields.add(field);
        }
        return matchingFields;
    }

    private static void addImport(PsiClass importPsiClass, PsiClass parentClass) {
        String classFqn = importPsiClass.getQualifiedName();
        if (classFqn == null) {
            return;
        }
        PsiFile psiFile = parentClass.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)psiFile;
            PsiImportList importList = javaFile.getImportList();
            if (importList == null) {
                JavaCodeStyleManager.getInstance((Project)parentClass.getProject()).addImport(javaFile, importPsiClass);
                return;
            }
            if (importList.findSingleImportStatement(classFqn) != null) {
                return;
            }
            PsiImportStatement importStatement = JavaPsiFacade.getElementFactory((Project)parentClass.getProject()).createImportStatement(importPsiClass);
            importList.add((PsiElement)importStatement);
            BcServiceMethodUpdaterUtils.shortenClassReferences((PsiElement)importStatement);
        }
    }

    private static void addImport(String fqn, PsiClass parentClass) {
        PsiFile psiFile = parentClass.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        if (importList.findSingleImportStatement(fqn) != null) {
            return;
        }
        PsiJavaFile aFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)parentClass.getProject()).createFileFromText("DUMMY_FILE", (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + fqn + ";"));
        PsiImportStatementBase statement = BcServiceMethodUpdaterUtils.extractImport(aFile, false);
        GeneratedMarkerVisitor.markGenerated((PsiElement)statement);
        importList.add((PsiElement)statement);
        BcServiceMethodUpdaterUtils.shortenClassReferences((PsiElement)statement);
    }

    private static void shortenClassReferences(Module module, PsiElement psiElement) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)module.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)module.getProject());
        styleManager.shortenClassReferences(psiElement);
        codeStyleManager.reformat(psiElement);
    }

    private static void shortenClassReferences(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return;
        }
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)module.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)module.getProject());
        styleManager.shortenClassReferences(psiElement);
        codeStyleManager.reformat(psiElement);
    }

    private static PsiImportStatementBase extractImport(PsiJavaFile aFile, boolean isStatic) {
        PsiImportStaticStatement[] statements;
        PsiImportList importList = aFile.getImportList();
        assert (importList != null) : aFile;
        Object[] objectArray = statements = isStatic ? importList.getImportStaticStatements() : importList.getImportStatements();
        assert (statements.length == 1) : aFile.getText();
        return statements[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiClass";
        objectArray2[1] = "org/cxbox/intellij/community/common/util/BcServiceMethodUpdaterUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodGetSpecification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodDoCreateEntity";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodGetList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodDoUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodBuildRowDependentMeta";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodBuildIndependentMeta";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public record SpecificationUpdateData(Boolean isParentBcVersionAware, String entity, String fieldName, String bc) {
    }
}

