/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.actionBuilder;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import org.cxbox.intellij.community.common.util.FeatureAvailabilityUtil;
import org.cxbox.intellij.community.java.actionBuilder.DeprecatedNewActionUsageConfig;
import org.cxbox.intellij.community.java.actionBuilder.DeprecatedNewActionUsageQuickFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeprecatedNewActionUsage
extends LocalInspectionTool {
    private static final int MAX_CHAIN_DEPTH_SEARCH = 100;

    @Nullable
    public static Pair<PsiMethodCallExpression, String> findCreateActionStartCall(PsiMethodCallExpression addCall) {
        PsiMethodCallExpression qualifierCall;
        PsiElement resolvedQualifier;
        PsiExpression qualifier;
        PsiMethodCallExpression currentCall = addCall;
        for (int i = 0; i < 100 && (qualifier = currentCall.getMethodExpression().getQualifierExpression()) instanceof PsiMethodCallExpression && (resolvedQualifier = (qualifierCall = (PsiMethodCallExpression)qualifier).getMethodExpression().resolve()) instanceof PsiMethod; ++i) {
            PsiMethod qualifierMethod = (PsiMethod)resolvedQualifier;
            String methodName = qualifierMethod.getName();
            if (DeprecatedNewActionUsageConfig.DEPRECATED_CREATE_ACTION_START_METHODS.stream().anyMatch(e -> e.name().equals(methodName)) && DeprecatedNewActionUsageConfig.ACTIONS_BUILDER_CLASS_PATTERN.accepts((Object)qualifierMethod.getContainingClass())) {
                return new Pair((Object)qualifierCall, (Object)methodName);
            }
            if (!DeprecatedNewActionUsageConfig.ACTION_DESCRIPTION_BUILDER_CLASS_PATTERN.accepts((Object)DeprecatedNewActionUsage.getReturnTypeClass(qualifierMethod))) break;
            currentCall = qualifierCall;
        }
        return null;
    }

    public static PsiClass getReturnTypeClass(PsiMethod method) {
        PsiType returnType = method.getReturnType();
        if (returnType instanceof PsiClassType) {
            return ((PsiClassType)returnType).resolve();
        }
        return null;
    }

    @Nullable
    public String getDescriptionFileName() {
        return "DeprecatedNewActionUsage.html";
    }

    @NotNull
    public String getDisplayName() {
        return "Deprecated action definition variants found (for example .newAction()...add() chain). Use recommended .action(act -> act.<chain>) syntax instead";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            DeprecatedNewActionUsage.$$$reportNull$$$0(0);
        }
        if (!FeatureAvailabilityUtil.isPlatformInScope(holder.getFile()) || !FeatureAvailabilityUtil.isLambdaActionBuilderAvailable(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DeprecatedNewActionUsage.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(this){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression addMethodCall) {
                if (addMethodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitMethodCallExpression(addMethodCall);
                if (DeprecatedNewActionUsageConfig.DEPRECATED_ADD_PATTERN.accepts((Object)addMethodCall)) {
                    Pair<PsiMethodCallExpression, String> newActionCall = DeprecatedNewActionUsage.findCreateActionStartCall(addMethodCall);
                    if (newActionCall == null) {
                        return;
                    }
                    PsiElement rangeStart = PsiTreeUtil.getChildOfType((PsiElement)((PsiMethodCallExpression)newActionCall.getFirst()).getMethodExpression(), PsiIdentifier.class);
                    PsiElement rangeEnd = PsiTreeUtil.getChildOfType((PsiElement)addMethodCall.getMethodExpression(), PsiIdentifier.class);
                    if (rangeStart != null && rangeEnd != null) {
                        holder.registerProblem(holder.getManager().createProblemDescriptor(rangeStart, rangeEnd, "Deprecated .newAction()...add() usage. Use the new lambda-based .action(act -> act.<chain>) instead.", ProblemHighlightType.WEAK_WARNING, isOnTheFly, new LocalQuickFix[]{new DeprecatedNewActionUsageQuickFix()}));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addMethodCall", "org/cxbox/intellij/community/java/actionBuilder/DeprecatedNewActionUsage$1", "visitMethodCallExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/java/actionBuilder/DeprecatedNewActionUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/java/actionBuilder/DeprecatedNewActionUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

