/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.java.requiredArgsConstructor;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.common.util.AnnotationUtil;
import org.cxbox.intellij.community.common.util.CoreUtil;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.java.requiredArgsConstructor.RequiredArgsConstructorFieldsExistsConfig;
import org.cxbox.intellij.community.wigdet.fields.field.generator.common.TemplatesKt;
import org.jetbrains.annotations.NotNull;

public abstract class RequiredArgsConstructorFieldsExistsInspectionAbstract
extends AbstractBaseJavaLocalInspectionTool {
    protected Optional<ProblemDescriptor> getProblemIfExists(@NotNull ReplaceCandidates replaceCandidates, @NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (replaceCandidates == null) {
            RequiredArgsConstructorFieldsExistsInspectionAbstract.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            RequiredArgsConstructorFieldsExistsInspectionAbstract.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            RequiredArgsConstructorFieldsExistsInspectionAbstract.$$$reportNull$$$0(2);
        }
        if (module == null) {
            RequiredArgsConstructorFieldsExistsInspectionAbstract.$$$reportNull$$$0(3);
        }
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, aClass.getProject());
        PsiClass ancestorClass = JavaUtil.getPsiClassByFqnPrefixWithoutPlatformRootPackage(aClass.getProject(), scp, replaceCandidates.clzForFieldTypeWithoutPrefix);
        if (ancestorClass != null) {
            boolean notContainFieldOrGetter;
            boolean bl = notContainFieldOrGetter = JavaUtil.getPsiClassFromFieldOrGetter(aClass, ancestorClass, replaceCandidates.fieldName) == null;
            if (notContainFieldOrGetter) {
                return Optional.of(holder.getManager().createProblemDescriptor((PsiElement)aClass, Objects.requireNonNull(aClass.getNameIdentifier()).getTextRangeInParent(), "To work correctly using @RequiredArgsConstructor, you need to add " + replaceCandidates.fieldName + " field.", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix(replaceCandidates, aClass, module)}));
            }
        }
        return Optional.empty();
    }

    private static String getTemplate(@NotNull ReplaceCandidates replaceCandidates, @NotNull PsiClass dto, @NotNull String initParameter) {
        if (replaceCandidates == null) {
            RequiredArgsConstructorFieldsExistsInspectionAbstract.$$$reportNull$$$0(4);
        }
        if (dto == null) {
            RequiredArgsConstructorFieldsExistsInspectionAbstract.$$$reportNull$$$0(5);
        }
        if (initParameter == null) {
            RequiredArgsConstructorFieldsExistsInspectionAbstract.$$$reportNull$$$0(6);
        }
        return switch (replaceCandidates.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> TemplatesKt.getMetaFieldForFieldMetaBuilder(dto, initParameter);
            case 1 -> TemplatesKt.getMetaFieldForAnySourceFieldMetaBuilder(dto, initParameter);
            case 2 -> TemplatesKt.getDaoFieldForAnySourceBaseDao(dto, initParameter);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceCandidates";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dto";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initParameter";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/java/requiredArgsConstructor/RequiredArgsConstructorFieldsExistsInspectionAbstract";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getProblemIfExists";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static enum ReplaceCandidates {
        META(".core.service.rowmeta.FieldMetaBuilder", ".core.crudma.impl.VersionAwareResponseService", 0, "meta", RequiredArgsConstructorFieldsExistsConfig.HAS_SUPER_VERSION_AWARE_RESPONSE_SERVICE),
        ANY_SOURCE_META(".core.service.rowmeta.AnySourceFieldMetaBuilder", ".core.crudma.impl.AnySourceVersionAwareResponseService", 0, "meta", RequiredArgsConstructorFieldsExistsConfig.HAS_SUPER_ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE),
        ANY_SOURCE_DAO(".core.dao.AnySourceBaseDAO", ".core.crudma.impl.AnySourceVersionAwareResponseService", 1, "dao", RequiredArgsConstructorFieldsExistsConfig.HAS_SUPER_ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE);

        public final String clzForFieldTypeWithoutPrefix;
        public final String ancestorClass;
        public final int indexInGeneric;
        public final String fieldName;
        public final ElementPattern<PsiClass> pattern;

        private ReplaceCandidates(String clzWithoutPrefix, String ancestorClass, int indexInGeneric, String fieldName, ElementPattern<PsiClass> pattern) {
            this.clzForFieldTypeWithoutPrefix = clzWithoutPrefix;
            this.ancestorClass = ancestorClass;
            this.indexInGeneric = indexInGeneric;
            this.fieldName = fieldName;
            this.pattern = pattern;
        }
    }

    public record Fix(ReplaceCandidates replaceCandidates, PsiClass enumBcService, Module module) implements LocalQuickFix
    {
        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = "Add " + this.replaceCandidates.fieldName + " field";
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = "Add " + this.replaceCandidates.fieldName + " field";
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(3);
            }
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                block10: {
                    try {
                        if (this.enumBcService.isValid()) {
                            PsiClass dto;
                            List<PsiClass> allChildFieldMetaBuilder = JavaUtil.getAllInheritorClasses(this.enumBcService.getProject(), this.module, CoreUtil.findCoreClass(this.replaceCandidates.clzForFieldTypeWithoutPrefix, this.enumBcService.getProject()).orElse(null));
                            PsiClass psiClass = dto = this.replaceCandidates.fieldName == "meta" ? (PsiClass)ResponseServiceUtils.getResponseServiceDto(this.enumBcService, project, this.module).orElse(null) : (PsiClass)JavaUtil.getPriClassFromGenericByIndexFromAncestorClassFqnWithoutPackegPrefix(this.enumBcService, this.replaceCandidates.ancestorClass, 1).orElse(null);
                            if (dto == null) {
                                throw new PlatformValidationException("cannot determine Dto of <a href=\"1\">Class</a> = " + this.enumBcService.getQualifiedName(), (NavigatablePsiElement)this.enumBcService, project);
                            }
                            List<PsiClass> ancestorClassesWithDto = CoreUtil.getCoreClassesHasAncestorClassWithDto(allChildFieldMetaBuilder, this.replaceCandidates.clzForFieldTypeWithoutPrefix, dto, 0);
                            if (ancestorClassesWithDto.size() == 1) {
                                String fieldText = TemplatesKt.getShortFieldForResponseServiceWithGetterFqn(ancestorClassesWithDto.get(0), this.replaceCandidates.fieldName);
                                PsiElementFactory elementFactory = PsiElementFactory.getInstance((Project)project);
                                PsiField fieldFromText = elementFactory.createFieldFromText(fieldText, (PsiElement)this.enumBcService);
                                PsiElement addedField = this.enumBcService.add((PsiElement)fieldFromText);
                                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(addedField);
                            } else {
                                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                                if (editor != null) {
                                    int offset = JavaUtil.getNextNewLineAfterClassName(this.enumBcService);
                                    editor.getCaretModel().moveToOffset(offset);
                                    editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
                                }
                                TemplateManager templateManage = TemplateManager.getInstance((Project)project);
                                templateManage.getActiveTemplate(editor);
                                Template template = templateManage.createTemplate("meta", "Platform Tools", RequiredArgsConstructorFieldsExistsInspectionAbstract.getTemplate(this.replaceCandidates, dto, "$CLASS_OBJECT$"));
                                template.setToReformat(true);
                                template.addVariable(new Variable("CLASS_OBJECT", "completeSmart()", "completeSmart()", true));
                                templateManage.startTemplate(editor, template);
                            }
                            if (this.replaceCandidates.ancestorClass.equals(".core.crudma.impl.AnySourceVersionAwareResponseService")) {
                                AnnotationUtil.addSuppressWarningsAnnotationWithNewValue(project, this.enumBcService, RequiredArgsConstructorFieldsExistsConfig.ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_VALUE_NEW_VALUE_LIST_FOR_ANY_SOURCE);
                            } else {
                                AnnotationUtil.addSuppressWarningsAnnotationWithNewValue(project, this.enumBcService, RequiredArgsConstructorFieldsExistsConfig.ANNOTATION_JAVA_LANG_SUPPRESS_WARNINGS_ATTRIBUTE_VALUE_NEW_VALUE_LIST_FOR_VERSION_AWARE);
                            }
                            break block10;
                        }
                        throw new PlatformValidationException("Class is not valid <a href=\"1\">Class</a> = " + this.enumBcService.getQualifiedName(), (NavigatablePsiElement)this.enumBcService, project);
                    }
                    catch (PlatformValidationException e) {
                        e.showPopupWithLinks();
                        throw e;
                    }
                    catch (Exception e) {
                        PlatformValidationException platformValidationException = new PlatformValidationException("Error during generation <a href=\"1\">Error message</a> = " + e.getMessage(), (NavigatablePsiElement)this.enumBcService, project);
                        platformValidationException.showPopupWithLinks();
                        throw platformValidationException;
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/java/requiredArgsConstructor/RequiredArgsConstructorFieldsExistsInspectionAbstract$Fix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/java/requiredArgsConstructor/RequiredArgsConstructorFieldsExistsInspectionAbstract$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

