/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.tool;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsSupplier;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RunPlatformInspectionsAction
extends AnAction {
    public static final String PLATFORM_INSPECTIONS_GROUP = "Platform";
    protected InspectionProfileImpl myExternalProfile;
    private int myRunId;
    private GlobalInspectionContextEx myGlobalInspectionContext;

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            this.analyze(project);
        }
    }

    public void analyze(Project project) {
        AnalysisScope analysisScope = new AnalysisScope(project);
        this.analyze(project, analysisScope);
    }

    protected void analyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            RunPlatformInspectionsAction.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            RunPlatformInspectionsAction.$$$reportNull$$$0(1);
        }
        try {
            this.runInspections(project, scope);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    protected void runInspections(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            RunPlatformInspectionsAction.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            RunPlatformInspectionsAction.$$$reportNull$$$0(3);
        }
        int runId = ++this.myRunId;
        scope.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        InspectionProfileImpl externalProfile = this.getExternalProfile();
        GlobalInspectionContextEx inspectionContext = this.getGlobalInspectionContext(project);
        inspectionContext.setRerunAction(() -> DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            if (runId != this.myRunId) {
                return;
            }
            if (project.isDisposed()) {
                return;
            }
            if (!scope.isValid()) {
                return;
            }
            this.myExternalProfile = externalProfile;
            this.myGlobalInspectionContext = inspectionContext;
            FileDocumentManager.getInstance().saveAllDocuments();
            this.analyze(project, scope);
        }));
        inspectionContext.setExternalProfile(externalProfile);
        inspectionContext.setCurrentScope(scope);
        inspectionContext.doInspections(scope);
    }

    private InspectionProfileImpl getExternalProfile() {
        if (this.myExternalProfile == null) {
            this.myExternalProfile = new InspectionProfileImpl("PlatformSpecificOnlyInspections", new InspectionToolsSupplier(this){

                @NotNull
                public List<InspectionToolWrapper<?, ?>> createTools() {
                    List<InspectionToolWrapper<?, ?>> list = InspectionToolRegistrar.getInstance().createTools().stream().filter(toolWrapper -> toolWrapper.getGroupDisplayName().contains(RunPlatformInspectionsAction.PLATFORM_INSPECTIONS_GROUP)).toList();
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/cxbox/intellij/community/tool/RunPlatformInspectionsAction$1", "createTools"));
                }
            }, (BaseInspectionProfileManager)InspectionProfileManager.getInstance());
        }
        return this.myExternalProfile;
    }

    private GlobalInspectionContextEx getGlobalInspectionContext(Project project) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance((Project)project)).createNewGlobalContext();
        }
        return this.myGlobalInspectionContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/tool/RunPlatformInspectionsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "analyze";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runInspections";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

