/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.view.widgets;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.jetbrains.annotations.NotNull;

public class ViewHasCreateEditWidgetInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "ViewHasCreateEditWidgetInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ViewHasCreateEditWidgetInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ViewHasCreateEditWidgetInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        SimpleNamedElement widgetFileInjectedName = JWidget.getWidgetFileInjectedName(jsonFile);
        this.extracted(manager, (List<ProblemDescriptor>)descriptors, jsonFile, project, module, (PsiElement)widgetFileInjectedName);
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void extracted(@NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> descriptors, @NotNull JsonFile jsonFile, @NotNull Project project, @NotNull Module module, PsiElement widgetFileInjectedName) {
        if (manager == null) {
            ViewHasCreateEditWidgetInspection.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            ViewHasCreateEditWidgetInspection.$$$reportNull$$$0(3);
        }
        if (jsonFile == null) {
            ViewHasCreateEditWidgetInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ViewHasCreateEditWidgetInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            ViewHasCreateEditWidgetInspection.$$$reportNull$$$0(6);
        }
        JWidget.getOptionsCreateEditWidgetProperties(jsonFile).stream().filter(Objects::nonNull).forEach(property -> {
            JsonValue patt0$temp;
            if (property.getValue() != null && (patt0$temp = property.getValue()) instanceof JsonStringLiteral) {
                JsonStringLiteral literal = (JsonStringLiteral)patt0$temp;
                String widgetName = JsonFacade.getValue(literal);
                List<ImmutablePair<JsonFile, PsiElement>> allViewsByWidgetName = JView.getAllViewsByWidgetName(project, module, widgetFileInjectedName);
                if (allViewsByWidgetName.isEmpty()) {
                    return;
                }
                GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
                Optional<JsonFile> widgetFromCreateEdit = JWidget.getWidgetByName(widgetName, scp, project, module);
                if (widgetFromCreateEdit.isEmpty()) {
                    return;
                }
                List<ImmutablePair<JsonFile, PsiElement>> allViewsByCreateEditWidget = JView.getAllViewsByWidgetName(project, module, (PsiElement)JWidget.getWidgetFileInjectedName(widgetFromCreateEdit.get()));
                List<String> viewNamesForCreatEditWidget = allViewsByCreateEditWidget.stream().map(Pair::getKey).filter(Objects::nonNull).map(PsiFileSystemItem::getName).toList();
                allViewsByWidgetName.stream().map(Pair::getKey).filter(Objects::nonNull).map(PsiFileSystemItem::getName).filter(name -> !viewNamesForCreatEditWidget.contains(name)).forEach(name -> {
                    JsonProperty createOrEdit = JsonFacade.getParentOfType((PsiElement)property, JsonProperty.class);
                    if (createOrEdit != null) {
                        descriptors.add(manager.createProblemDescriptor((PsiElement)property, property.getValue().getTextRangeInParent(), "The view '" + name + "' does not contain a " + property.getName() + " widget '" + String.valueOf(widgetFromCreateEdit.get()) + "'", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix(this.getViewByName(allViewsByWidgetName, (String)name), widgetName, "Add " + createOrEdit.getName() + " widget '" + widgetName + "' to '" + name + "'")}));
                    }
                });
            }
        });
    }

    private JsonFile getViewByName(List<ImmutablePair<JsonFile, PsiElement>> files, String name) {
        return files.stream().map(Pair::getKey).filter(file -> name.equals(file.getName())).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/view/widgets/ViewHasCreateEditWidgetInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extracted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        private final JsonFile viewFile;
        private final String name;
        private final String msg;

        public Fix(JsonFile viewFile, String name, String msg) {
            this.viewFile = viewFile;
            this.name = name;
            this.msg = msg;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.msg;
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.msg;
            if (string == null) {
                Fix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Module module;
            if (project == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(3);
            }
            if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)descriptor.getPsiElement())) == null) {
                return;
            }
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(descriptor.getPsiElement().getContainingFile().getVirtualFile());
            WriteAction.run(() -> JView.addWidgetToView(this.name, this.viewFile));
            EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
            if (editor != null) {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/view/widgets/ViewHasCreateEditWidgetInspection$Fix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/view/widgets/ViewHasCreateEditWidgetInspection$Fix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

