/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.view.widgets;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;

public final class ViewWidgetNameDuplicateInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "ViewWidgetNameDuplicateInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ViewWidgetNameDuplicateInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ViewWidgetNameDuplicateInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return null;
        }
        JsonFile viewFile = (JsonFile)file;
        if (!file.getName().endsWith("view.json")) {
            return null;
        }
        JsonArray viewFileWidgetsArray = JsonFacade.safeGetPropertyValueOfType(JsonFacade.getTopLevelObject(viewFile), JView.WIDGETS);
        List<JsonValue> viewFileWidgetsObjects = JsonFacade.getChildrenOfTypeAsList((PsiElement)viewFileWidgetsArray, JView.WIDGETS.arrayItemType());
        Map<String, List<JsonObject>> viewWidgetsGroupedByName = viewFileWidgetsObjects.stream().filter(Objects::nonNull).collect(JavaUtil.groupingByWithNullKeys(viewWidgetsObject -> JsonFacade.safeGetValueAsString((PsiElement)JsonFacade.safeGetPropertyValueOfType(viewWidgetsObject, JView.WIDGETS_WIDGET_NAME))));
        Map<String, List> viewWidgetDuplicates = viewWidgetsGroupedByName.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        SmartList descriptors = new SmartList();
        viewWidgetDuplicates.forEach((arg_0, arg_1) -> ViewWidgetNameDuplicateInspection.lambda$checkFile$2((List)descriptors, manager, arg_0, arg_1));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static /* synthetic */ void lambda$checkFile$2(List descriptors, InspectionManager manager, String duplicateName, List duplicateObjects) {
        Iterator iterator = duplicateObjects.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            JsonObject widget = (JsonObject)iterator.next();
            JsonStringLiteral widgetName = JsonFacade.safeGetPropertyValueOfType(widget, JView.WIDGETS_WIDGET_NAME);
            descriptors.add(manager.createProblemDescriptor((PsiElement)widgetName, new TextRange(1, widgetName.getValue().length() + 1), "Duplicate. Tag widgets [] already contains object with same widgetName", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix()}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "org/cxbox/intellij/community/view/widgets/ViewWidgetNameDuplicateInspection";
        objectArray[2] = "checkFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        private Fix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Delete duplicate";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Duplicate";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElement element = descriptor.getPsiElement();
            JsonObject widgetObject = JsonFacade.getParentOfType(element, JsonObject.class);
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
                if (widgetObject != null) {
                    JsonObject prevWidgetObject = (JsonObject)JsonFacade.getPrevSiblingOfType((PsiElement)widgetObject, JView.WIDGETS.arrayItemType());
                    JsonArray widgets = JsonFacade.getParentOfType((PsiElement)widgetObject, JView.WIDGETS.valueType());
                    if (widgets != null && prevWidgetObject != null && prevWidgetObject.getNextSibling() != widgetObject) {
                        widgets.deleteChildRange(prevWidgetObject.getNextSibling(), (PsiElement)widgetObject);
                    } else {
                        widgetObject.delete();
                    }
                }
                QuickFixUtils.safeDoPostponedOperationsIfPossible(project, element);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/view/widgets/ViewWidgetNameDuplicateInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

