/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.type;

import com.google.common.base.Charsets;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.conf.JView;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.BcUtil;
import org.cxbox.intellij.community.common.util.JavaFacade;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.language.SimpleNamedElement;
import org.cxbox.intellij.community.wigdet.fields.field.generator.common.ResponseServiceWidgetNewFieldGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PopupWidgetInspection
extends LocalInspectionTool {
    public abstract String getNeededWidgetType();

    public abstract PsiElementPattern.Capture<JsonValue> getWidgetFilePopUpBcPattern();

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            PopupWidgetInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PopupWidgetInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        SimpleNamedElement widgetFileInjectedName = JWidget.getWidgetFileInjectedName(jsonFile);
        Arrays.stream(file.getChildren()).filter(Objects::nonNull).forEach(arg_0 -> this.lambda$checkFile$0(manager, (List)descriptors, project, module, (PsiElement)widgetFileInjectedName, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void extracted(@NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> descriptors, @NotNull PsiElement widgetFilePopUpBc, @NotNull Project project, @NotNull Module module, PsiElement widgetFileInjectedName) {
        if (manager == null) {
            PopupWidgetInspection.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            PopupWidgetInspection.$$$reportNull$$$0(3);
        }
        if (widgetFilePopUpBc == null) {
            PopupWidgetInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PopupWidgetInspection.$$$reportNull$$$0(5);
        }
        if (module == null) {
            PopupWidgetInspection.$$$reportNull$$$0(6);
        }
        if (this.getWidgetFilePopUpBcPattern().accepts((Object)widgetFilePopUpBc)) {
            String popUpBc = JsonFacade.getValue((JsonStringLiteral)widgetFilePopUpBc);
            Optional link = (Optional)BcUtil.getLinkAndAutocompletionByBc(popUpBc, project, module).getFirst();
            if (link.isEmpty()) {
                return;
            }
            List<JView.Result> viewFileAllPopUpBcWidgetsInViewsOfCurrentWidget = JView.getAllViewsByWidgetInjectedNameAndAllWidgetsThatHaveBc(popUpBc, project, module, widgetFileInjectedName);
            viewFileAllPopUpBcWidgetsInViewsOfCurrentWidget.forEach(result -> {
                if (result.widgetNames().isEmpty()) {
                    descriptors.add(manager.createProblemDescriptor(widgetFilePopUpBc, new TextRange(1, popUpBc.length() + 1), "main widget '" + widgetFilePopUpBc.getContainingFile().getName() + "' is referenced on view '" + result.view().getContainingFile().getName() + "', but popupBcName '" + popUpBc + "' does not have widget on this view", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix((JsonFile)result.view().getContainingFile(), "Add popup widget to '" + result.view().getContainingFile().getName() + "'", this.getNeededWidgetType())}));
                }
            });
        } else {
            Arrays.stream(widgetFilePopUpBc.getChildren()).forEach(c2 -> this.extracted(manager, descriptors, (PsiElement)c2, project, module, widgetFileInjectedName));
        }
    }

    @NotNull
    private static Optional<JsonProperty> getKey(@NotNull PsiElement element) {
        if (element == null) {
            PopupWidgetInspection.$$$reportNull$$$0(7);
        }
        JsonObject widgetPickListField = JsonFacade.getParentOfType(element, JsonObject.class);
        Optional<JsonProperty> optional = JsonFacade.getPropertyChildByName(widgetPickListField, "key");
        if (optional == null) {
            PopupWidgetInspection.$$$reportNull$$$0(8);
        }
        return optional;
    }

    private static boolean isMultivalue(@NotNull PsiElement element) {
        if (element == null) {
            PopupWidgetInspection.$$$reportNull$$$0(9);
        }
        JsonObject widgetPickListField = JsonFacade.getParentOfType(element, JsonObject.class);
        String type = PopupWidgetInspection.getValue(JsonFacade.getPropertyChildByName(widgetPickListField, "type"));
        return "multivalue".equals(type);
    }

    @NotNull
    private static String getValue(Optional<JsonProperty> property) {
        String string = property.map(JsonFacade::getStringValue).orElse("");
        if (string == null) {
            PopupWidgetInspection.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static Optional<JsonProperty> getValueFromPickMapByKey(@NotNull PsiElement element, @NotNull String key) {
        JsonValue jsonValue;
        JsonObject widgetPickListField;
        Optional<JsonProperty> pickMap;
        if (element == null) {
            PopupWidgetInspection.$$$reportNull$$$0(11);
        }
        if (key == null) {
            PopupWidgetInspection.$$$reportNull$$$0(12);
        }
        if ((pickMap = JsonFacade.getPropertyChildByName(widgetPickListField = JsonFacade.getParentOfType(element, JsonObject.class), "pickMap")).isPresent() && (jsonValue = pickMap.get().getValue()) instanceof JsonObject) {
            JsonObject pickMapObject = (JsonObject)jsonValue;
            Optional<JsonProperty> optional = JsonFacade.getPropertyChildByName(pickMapObject, key);
            if (optional == null) {
                PopupWidgetInspection.$$$reportNull$$$0(13);
            }
            return optional;
        }
        Optional<JsonProperty> optional = Optional.empty();
        if (optional == null) {
            PopupWidgetInspection.$$$reportNull$$$0(14);
        }
        return optional;
    }

    @NotNull
    private static Optional<JsonProperty> getAssocValueKey(@NotNull PsiElement element) {
        if (element == null) {
            PopupWidgetInspection.$$$reportNull$$$0(15);
        }
        JsonObject widgetPickListField = JsonFacade.getParentOfType(element, JsonObject.class);
        Optional<JsonProperty> optional = JsonFacade.getPropertyChildByName(widgetPickListField, "assocValueKey");
        if (optional == null) {
            PopupWidgetInspection.$$$reportNull$$$0(16);
        }
        return optional;
    }

    @NotNull
    private static String getWidgetFieldType(Optional<JsonProperty> property, Module module, Project project) {
        Optional<PsiElement> entityField = property.map(JsonProperty::getValue).map(value -> {
            if (value.getReferences().length > 0) {
                return value.getReferences()[0];
            }
            return null;
        }).map(PsiReference::resolve);
        String string = entityField.map(field -> {
            if (field instanceof PsiField) {
                PsiField psiField = (PsiField)field;
                return psiField;
            }
            return null;
        }).map(field -> {
            PsiType patt0$temp = field.getType();
            if (patt0$temp instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)patt0$temp;
                PsiClass fieldCLass = classType.resolve();
                if (fieldCLass.isEnum()) {
                    return JsonFacade.JAVA_TYPE_TO_JSON_TYPE.get("Enum");
                }
                if (ResponseServiceWidgetNewFieldGenerator.Companion.isDictionary(fieldCLass, Cache.getPlatformRootPackageWithoutDot(project, module))) {
                    return JsonFacade.JAVA_TYPE_TO_JSON_TYPE.get("Dictionary");
                }
                return JsonFacade.JAVA_TYPE_TO_JSON_TYPE.getOrDefault(fieldCLass.getQualifiedName(), "");
            }
            return "";
        }).orElse("");
        if (string == null) {
            PopupWidgetInspection.$$$reportNull$$$0(17);
        }
        return string;
    }

    private /* synthetic */ void lambda$checkFile$0(InspectionManager manager, List descriptors, Project project, Module module, PsiElement widgetFileInjectedName, PsiElement c) {
        this.extracted(manager, descriptors, c, project, module, widgetFileInjectedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 13, 14, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetFilePopUpBc";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/field/type/PopupWidgetInspection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/type/PopupWidgetInspection";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueFromPickMapByKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssocValueKey";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extracted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMultivalue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValueFromPickMapByKey";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAssocValueKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 13, 14, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class Fix
    implements LocalQuickFix {
        private final JsonFile viewFile;
        private final String name;
        private final String neededWidgetType;

        public Fix(JsonFile viewFile, String name, String neededWidgetType) {
            this.viewFile = viewFile;
            this.name = name;
            this.neededWidgetType = neededWidgetType;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                Fix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Select correct value";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                Fix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if ((psiElement = descriptor.getPsiElement()) instanceof JsonStringLiteral) {
                JsonStringLiteral widgetFilePopUpBc = (JsonStringLiteral)psiElement;
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)widgetFilePopUpBc);
                if (module == null) {
                    return;
                }
                String popUpBc = JsonFacade.getValue(widgetFilePopUpBc);
                FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(widgetFilePopUpBc.getContainingFile().getVirtualFile());
                try {
                    WriteAction.run(() -> {
                        List<String> widgets = this.getWidgetNamesOfTypeAndBc(popUpBc, this.neededWidgetType, project, module);
                        if (!widgets.isEmpty()) {
                            JView.addWidgetToView(widgets.get(0), this.viewFile);
                        } else {
                            String path = widgetFilePopUpBc.getContainingFile().getContainingDirectory().getVirtualFile().getPath();
                            VirtualFile parent = VfsUtil.createDirectoryIfMissing((String)path);
                            String widgetName = !popUpBc.endsWith(this.neededWidgetType) ? popUpBc + this.neededWidgetType : popUpBc;
                            VirtualFile newFile = parent.createChildData((Object)this, widgetName + ".widget.json");
                            String keyStringValue = PopupWidgetInspection.getValue(PopupWidgetInspection.getKey((PsiElement)widgetFilePopUpBc));
                            Optional<JsonProperty> valueKeyFromEntity = PopupWidgetInspection.isMultivalue((PsiElement)widgetFilePopUpBc) ? PopupWidgetInspection.getAssocValueKey((PsiElement)widgetFilePopUpBc) : PopupWidgetInspection.getValueFromPickMapByKey((PsiElement)widgetFilePopUpBc, keyStringValue);
                            String s = "{\n  \"name\": \"" + widgetName + "\",\n  \"title\": \"" + widgetName + " title\",\n  \"type\": \"" + this.neededWidgetType + "\",\n  \"bc\": \"" + popUpBc + "\",\n  \"fields\": [\n    {\n      \"title\": \"id\",\n      \"key\": \"id\",\n      \"type\": \"text\"\n    },\n    {\n      \"title\": \"" + JavaFacade.convertToCamelCase(keyStringValue) + "\",\n      \"key\": \"" + PopupWidgetInspection.getValue(valueKeyFromEntity) + "\",\n      \"type\": \"" + PopupWidgetInspection.getWidgetFieldType(valueKeyFromEntity, module, project) + "\"\n    }\n  ]\n}\n";
                            newFile.setBinaryContent(s.getBytes(Charsets.UTF_8));
                            PsiFile file = PsiManager.getInstance((Project)project).findFile(newFile);
                            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
                            JView.addWidgetToView(widgetName, this.viewFile);
                        }
                    });
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                EditorEx editor = EditorUtil.getEditorEx((FileEditor)fileEditor);
                if (editor != null) {
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument((Document)editor.getDocument());
                }
            }
        }

        @NotNull
        private List<String> getWidgetNamesOfTypeAndBc(@Nullable String neededBc, @Nullable String neededWidgetType, @NotNull Project project, @NotNull Module module) {
            if (project == null) {
                Fix.$$$reportNull$$$0(3);
            }
            if (module == null) {
                Fix.$$$reportNull$$$0(4);
            }
            if (neededBc == null || neededWidgetType == null) {
                return new ArrayList<String>();
            }
            List<String> list = JWidget.getAllWidgetFiles(project, module).stream().filter(file -> {
                JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
                JsonStringLiteral widgetBc = JsonFacade.safeGetPropertyValueOfType(topLevelObject, JWidget.BC);
                if (widgetBc == null || !Objects.equals(neededBc, JsonFacade.getValue(widgetBc))) {
                    return false;
                }
                JsonStringLiteral widgetType = JsonFacade.safeGetPropertyValueOfType(topLevelObject, JWidget.TYPE);
                return widgetType != null && Objects.equals(neededWidgetType, JsonFacade.getValue(widgetType));
            }).map(file -> {
                JsonObject topLevelObject = JsonFacade.getTopLevelObject(file);
                JsonStringLiteral widgetName = JsonFacade.safeGetPropertyValueOfType(topLevelObject, JWidget.NAME);
                return widgetName != null ? JsonFacade.getValue(widgetName) : null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (list == null) {
                Fix.$$$reportNull$$$0(5);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/field/type/PopupWidgetInspection$Fix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/type/PopupWidgetInspection$Fix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWidgetNamesOfTypeAndBc";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getWidgetNamesOfTypeAndBc";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

