/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.options.inlinewidget;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.SmartList;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionInlineWidgetsBcInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String bcOptionEdit;
        String bcOptionCreate;
        if (file == null) {
            OptionInlineWidgetsBcInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            OptionInlineWidgetsBcInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return null;
        }
        JsonFile widgetFile = (JsonFile)file;
        if (!file.getName().endsWith(".widget.json")) {
            return null;
        }
        String bcWidget = JWidget.getWidgetBC(widgetFile);
        if (bcWidget == null) {
            return null;
        }
        JsonObject topLevelValue = JsonFacade.getTopLevelObject(widgetFile);
        JsonObject options = JsonFacade.safeGetPropertyValueOfType(topLevelValue, JWidget.OPTIONS);
        JsonObject optionsCreate = JsonFacade.safeGetPropertyValueOfType(options, JWidget.OPTIONS_CREATE);
        JsonObject optionsEdit = JsonFacade.safeGetPropertyValueOfType(options, JWidget.OPTIONS_EDIT);
        JsonObject optionsRead = JsonFacade.safeGetPropertyValueOfType(options, JWidget.OPTIONS_READ);
        JsonStringLiteral optionsCreateWidget = JsonFacade.safeGetPropertyValueOfType(optionsCreate, JWidget.OPTIONS_CREATE_WIDGET);
        JsonStringLiteral optionsEditWidget = JsonFacade.safeGetPropertyValueOfType(optionsEdit, JWidget.OPTIONS_EDIT_WIDGET);
        JsonStringLiteral optionReadWidget = JsonFacade.safeGetPropertyValueOfType(optionsRead, JWidget.OPTIONS_READ_WIDGET);
        if (optionsCreateWidget == null && optionsEditWidget == null && optionReadWidget == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        if (optionsCreateWidget != null && !bcWidget.equals(bcOptionCreate = this.bcNameFromReferenceWidget((JsonLiteral)optionsCreateWidget))) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)file, optionsCreateWidget.getTextRange(), "Create widget have not equivalent bc with parent widget bc!", ProblemHighlightType.WARNING, true, new LocalQuickFix[0]));
        }
        if (optionsEditWidget != null && !bcWidget.equals(bcOptionEdit = this.bcNameFromReferenceWidget((JsonLiteral)optionsEditWidget))) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)file, optionsEditWidget.getTextRange(), "Create widget have not equivalent bc with parent widget bc!", ProblemHighlightType.WARNING, true, new LocalQuickFix[0]));
        }
        if (optionReadWidget != null && !bcWidget.equals(bcOptionEdit = this.bcNameFromReferenceWidget((JsonLiteral)optionReadWidget))) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)file, optionReadWidget.getTextRange(), "Read widget have not equivalent bc with parent widget bc!", ProblemHighlightType.WARNING, true, new LocalQuickFix[0]));
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private String bcNameFromReferenceWidget(@NotNull JsonLiteral jsonLiteral) {
        if (jsonLiteral == null) {
            OptionInlineWidgetsBcInspection.$$$reportNull$$$0(2);
        }
        PsiElement target = null;
        block0: for (PsiReference reference : jsonLiteral.getReferences()) {
            if (reference instanceof PsiPolyVariantReference) {
                PsiPolyVariantReference psiPolyVariantReference = (PsiPolyVariantReference)reference;
                for (ResolveResult result : psiPolyVariantReference.multiResolve(false)) {
                    if (!result.isValidResult()) continue;
                    target = result.getElement();
                    continue block0;
                }
                continue;
            }
            target = reference.resolve();
        }
        if (target == null) {
            return null;
        }
        PsiFile fileFromReference = this.getPsiFileFromVirtualFile(target.getContainingFile().getVirtualFile(), target.getProject());
        if (!(fileFromReference instanceof JsonFile)) {
            return null;
        }
        JsonFile widgetFile = (JsonFile)fileFromReference;
        return JWidget.getWidgetBC(widgetFile);
    }

    private PsiFile getPsiFileFromVirtualFile(VirtualFile file, Project project) {
        VirtualFile vf = file;
        if (file instanceof VirtualFileWindow) {
            VirtualFileWindow vfw = (VirtualFileWindow)file;
            vf = vfw.getDelegate();
        }
        return PsiManager.getInstance((Project)project).findFile(vf);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonLiteral";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/options/inlinewidget/OptionInlineWidgetsBcInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bcNameFromReferenceWidget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

