/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.refToOtherWidget;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Optional;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.wigdet.refToOtherWidget.WidgetReferenceContributor;
import org.jetbrains.annotations.NotNull;

public class WidgetReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            WidgetReferenceInspection.$$$reportNull$$$0(0);
        }
        if (!((file = holder.getFile()) instanceof JsonFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WidgetReferenceInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        if (!file.getName().endsWith(".widget.json")) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WidgetReferenceInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        final Project project = file.getProject();
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                WidgetReferenceInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new JsonElementVisitor(this){

            public void visitProperty(@NotNull JsonProperty property) {
                String widgetNameFromProperty;
                Optional link;
                if (property == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (property.getValue() != null && WidgetReferenceContributor.Holder.WIDGET_REF_PATTERN.accepts((Object)property.getValue()) && property.getValue().getText() != null && (link = (Optional)JWidget.getLinkAndAutocompletionByWidgetName(widgetNameFromProperty = property.getValue().getText().replace("\"", ""), project, module).getFirst()).isEmpty()) {
                    InspectionManager manager = InspectionManager.getInstance((Project)project);
                    holder.registerProblem(manager.createProblemDescriptor((PsiElement)property.getValue(), new TextRange(1, widgetNameFromProperty.length() + 1), "Incorrect value. Use autocomplete to provide correct one", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new Fix()}));
                }
                super.visitProperty(property);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/cxbox/intellij/community/wigdet/refToOtherWidget/WidgetReferenceInspection$1", "visitProperty"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/refToOtherWidget/WidgetReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/refToOtherWidget/WidgetReferenceInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class Fix
    implements LocalQuickFix {
        private Fix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Select value with autocompletion";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Select value with autocompletion";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            QuickFixUtils.clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/refToOtherWidget/WidgetReferenceInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

