/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonPsiImplUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.cxbox.intellij.community.common.conf.JsonTag;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonFacade {
    public static Map<String, String> JAVA_TYPE_TO_JSON_TYPE = Map.of("java.lang.String", "input", "java.time.LocalDateTime", "date", "java.lang.Long", "number", "java.lang.Double", "number", "Enum", "dictionary", "Dictionary", "dictionary", "java.lang.Boolean", "checkbox ");

    public static boolean isJsonFile(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            JsonFacade.$$$reportNull$$$0(0);
        }
        return JsonUtil.isJsonFile((VirtualFile)file, (Project)project);
    }

    @Nullable
    public static JsonObject getTopLevelObject(@Nullable JsonFile context) {
        return JsonUtil.getTopLevelObject((JsonFile)context);
    }

    public static <T extends JsonElement> T getPropertyValueOfType(@NotNull JsonObject object, @NotNull String name, @NotNull Class<T> clazz) {
        if (object == null) {
            JsonFacade.$$$reportNull$$$0(1);
        }
        if (name == null) {
            JsonFacade.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            JsonFacade.$$$reportNull$$$0(3);
        }
        return (T)JsonUtil.getPropertyValueOfType((JsonObject)object, (String)name, clazz);
    }

    @Nullable
    public static <T extends JsonElement & JsonValue> T safeGetPropertyValueOfType(JsonObject object, @NotNull JsonTag<T> jsonTag) {
        if (jsonTag == null) {
            JsonFacade.$$$reportNull$$$0(4);
        }
        if (object == null) {
            return null;
        }
        return (T)JsonUtil.getPropertyValueOfType((JsonObject)object, (String)jsonTag.getName(), jsonTag.valueType());
    }

    @Nullable
    public static <T extends JsonElement> T safeGetPropertyValueOfType(JsonObject object, @NotNull String name, @NotNull Class<T> clazz) {
        if (name == null) {
            JsonFacade.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            JsonFacade.$$$reportNull$$$0(6);
        }
        if (object == null) {
            return null;
        }
        return (T)JsonUtil.getPropertyValueOfType((JsonObject)object, (String)name, clazz);
    }

    public static int getArrayIndexOfItem(@NotNull PsiElement e) {
        if (e == null) {
            JsonFacade.$$$reportNull$$$0(7);
        }
        return JsonUtil.getArrayIndexOfItem((PsiElement)e);
    }

    public static boolean isArrayElement(@NotNull PsiElement element) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(8);
        }
        return JsonPsiUtil.isArrayElement((PsiElement)element);
    }

    public static boolean isPropertyKey(@NotNull PsiElement element) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(9);
        }
        return JsonPsiUtil.isPropertyKey((PsiElement)element);
    }

    public static boolean isPropertyValue(@NotNull PsiElement element) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(10);
        }
        return JsonPsiUtil.isPropertyValue((PsiElement)element);
    }

    @NotNull
    public static PsiElement findFurthestSiblingOfSameType(@NotNull PsiElement anchor, boolean after) {
        if (anchor == null) {
            JsonFacade.$$$reportNull$$$0(11);
        }
        PsiElement psiElement = JsonPsiUtil.findFurthestSiblingOfSameType((PsiElement)anchor, (boolean)after);
        if (psiElement == null) {
            JsonFacade.$$$reportNull$$$0(12);
        }
        return psiElement;
    }

    @NotNull
    public static String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(13);
        }
        String string = JsonPsiUtil.getElementTextWithoutHostEscaping((PsiElement)element);
        if (string == null) {
            JsonFacade.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String stripQuotes(@NotNull String text) {
        if (text == null) {
            JsonFacade.$$$reportNull$$$0(15);
        }
        String string = JsonPsiUtil.stripQuotes((String)text);
        if (string == null) {
            JsonFacade.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static PsiElement addProperty(@NotNull JsonObject object, @NotNull JsonProperty property, boolean first) {
        if (object == null) {
            JsonFacade.$$$reportNull$$$0(17);
        }
        if (property == null) {
            JsonFacade.$$$reportNull$$$0(18);
        }
        PsiElement psiElement = JsonPsiUtil.addProperty((JsonObject)object, (JsonProperty)property, (boolean)first);
        if (psiElement == null) {
            JsonFacade.$$$reportNull$$$0(19);
        }
        return psiElement;
    }

    @NotNull
    public static Set<String> getOtherSiblingPropertyNames(@Nullable JsonProperty property) {
        Set set = JsonPsiUtil.getOtherSiblingPropertyNames((JsonProperty)property);
        if (set == null) {
            JsonFacade.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public static String getValue(@NotNull JsonStringLiteral literal) {
        if (literal == null) {
            JsonFacade.$$$reportNull$$$0(21);
        }
        String string = JsonPsiImplUtils.getValue((JsonStringLiteral)literal);
        if (string == null) {
            JsonFacade.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String getStringValue(@NotNull JsonProperty property) {
        JsonValue jsonValue;
        if (property == null) {
            JsonFacade.$$$reportNull$$$0(23);
        }
        if ((jsonValue = property.getValue()) instanceof JsonStringLiteral) {
            JsonStringLiteral literal = (JsonStringLiteral)jsonValue;
            String string = JsonPsiImplUtils.getValue((JsonStringLiteral)literal);
            if (string == null) {
                JsonFacade.$$$reportNull$$$0(24);
            }
            return string;
        }
        return "";
    }

    @Nullable
    public static Double safeGetValueAsDouble(@Nullable PsiElement element) {
        if (element instanceof JsonNumberLiteral) {
            JsonNumberLiteral literal = (JsonNumberLiteral)element;
            return JsonPsiImplUtils.getValue((JsonNumberLiteral)literal);
        }
        return null;
    }

    @Nullable
    public static String safeGetValueAsString(@Nullable PsiElement element) {
        if (element instanceof JsonStringLiteral) {
            JsonStringLiteral literal = (JsonStringLiteral)element;
            return JsonPsiImplUtils.getValue((JsonStringLiteral)literal);
        }
        return null;
    }

    public static boolean getValue(@NotNull JsonBooleanLiteral literal) {
        if (literal == null) {
            JsonFacade.$$$reportNull$$$0(25);
        }
        return JsonPsiImplUtils.getValue((JsonBooleanLiteral)literal);
    }

    public static double getValue(@NotNull JsonNumberLiteral literal) {
        if (literal == null) {
            JsonFacade.$$$reportNull$$$0(26);
        }
        return JsonPsiImplUtils.getValue((JsonNumberLiteral)literal);
    }

    @Nullable
    public static JsonValue getValue(@NotNull JsonProperty property) {
        if (property == null) {
            JsonFacade.$$$reportNull$$$0(27);
        }
        return JsonPsiImplUtils.getValue((JsonProperty)property);
    }

    @Nullable
    public static String getValueAsString(@Nullable JsonProperty property) {
        JsonValue jsonValue;
        if (property != null && (jsonValue = JsonPsiImplUtils.getValue((JsonProperty)property)) instanceof JsonStringLiteral) {
            JsonStringLiteral literal = (JsonStringLiteral)jsonValue;
            return JsonFacade.getValue(literal);
        }
        return null;
    }

    @NotNull
    public static JsonValue getNameElement(@NotNull JsonProperty property) {
        if (property == null) {
            JsonFacade.$$$reportNull$$$0(28);
        }
        JsonValue jsonValue = JsonPsiImplUtils.getNameElement((JsonProperty)property);
        if (jsonValue == null) {
            JsonFacade.$$$reportNull$$$0(29);
        }
        return jsonValue;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isAncestor(@Nullable PsiElement ancestor, @NotNull PsiElement element, boolean strict) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(30);
        }
        return PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)element, (boolean)strict);
    }

    @Nullable
    public static PsiElement findCommonParent(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            JsonFacade.$$$reportNull$$$0(31);
        }
        return PsiTreeUtil.findCommonParent(elements);
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement ... elements) {
        if (elements == null) {
            JsonFacade.$$$reportNull$$$0(32);
        }
        return PsiTreeUtil.findCommonParent((PsiElement[])elements);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(33);
        }
        return (T)PsiTreeUtil.findChildOfType((PsiElement)element, aClass);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(34);
        }
        return (T)PsiTreeUtil.findChildOfType((PsiElement)element, aClass, (boolean)strict);
    }

    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, @Nullable Class<? extends PsiElement> stopAt) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(35);
        }
        return (T)PsiTreeUtil.findChildOfType((PsiElement)element, aClass, (boolean)strict, stopAt);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(36);
        }
        return (T)PsiTreeUtil.findChildOfAnyType((PsiElement)element, (Class[])classes);
    }

    @SafeVarargs
    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T findChildOfAnyType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(37);
        }
        return (T)PsiTreeUtil.findChildOfAnyType((PsiElement)element, (boolean)strict, (Class[])classes);
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfType(@Nullable PsiElement element, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(38);
        }
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)element, aClass);
        if (collection == null) {
            JsonFacade.$$$reportNull$$$0(39);
        }
        return collection;
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(40);
        }
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)element, (Class[])classes);
        if (collection == null) {
            JsonFacade.$$$reportNull$$$0(41);
        }
        return collection;
    }

    @SafeVarargs
    @NotNull
    public static <T extends PsiElement> Collection<T> findChildrenOfAnyType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(42);
        }
        Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)element, (boolean)strict, (Class[])classes);
        if (collection == null) {
            JsonFacade.$$$reportNull$$$0(43);
        }
        return collection;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getChildOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(44);
        }
        return (T)PsiTreeUtil.getChildOfType((PsiElement)element, aClass);
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            JsonFacade.$$$reportNull$$$0(45);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, condition);
    }

    @Nullable
    public static PsiElement findFirstParent(@Nullable PsiElement element, boolean strict, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            JsonFacade.$$$reportNull$$$0(46);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)strict, condition);
    }

    public static int countChildrenOfType(@NotNull PsiElement element, @NotNull Class<? extends PsiElement> clazz) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(47);
        }
        if (clazz == null) {
            JsonFacade.$$$reportNull$$$0(48);
        }
        return PsiTreeUtil.countChildrenOfType((PsiElement)element, clazz);
    }

    public static <T extends PsiElement> T[] getChildrenOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(49);
        }
        return PsiTreeUtil.getChildrenOfType((PsiElement)element, aClass);
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(50);
        }
        List list = PsiTreeUtil.getChildrenOfAnyType((PsiElement)element, (Class[])classes);
        if (list == null) {
            JsonFacade.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    public static <T extends PsiElement> List<T> getChildrenOfTypeAsList(@Nullable PsiElement element, @NotNull Class<? extends T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(52);
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, aClass);
        if (list == null) {
            JsonFacade.$$$reportNull$$$0(53);
        }
        return list;
    }

    @NotNull
    public static List<PsiElement> getElementsOfRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            JsonFacade.$$$reportNull$$$0(54);
        }
        if (end == null) {
            JsonFacade.$$$reportNull$$$0(55);
        }
        List list = PsiTreeUtil.getElementsOfRange((PsiElement)start, (PsiElement)end);
        if (list == null) {
            JsonFacade.$$$reportNull$$$0(56);
        }
        return list;
    }

    public static boolean instanceOf(Object object, Class<?> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(57);
        }
        return PsiTreeUtil.instanceOf((Object)object, (Class[])classes);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getChildOfAnyType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        return (T)PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])classes);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getNextSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(58);
        }
        return (T)PsiTreeUtil.getNextSiblingOfType((PsiElement)sibling, aClass);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getPrevSiblingOfType(@Nullable PsiElement sibling, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(59);
        }
        return (T)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, aClass);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getTopmostParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(60);
        }
        return (T)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, aClass);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(61);
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)element, aClass);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(62);
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)element, aClass, (boolean)strict);
    }

    @Contract(value="null, _, _, _ -> null")
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, int minStartOffset) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(63);
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)element, aClass, (boolean)strict, (int)minStartOffset);
    }

    @SafeVarargs
    @Contract(value="null, _, _, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, boolean strict, Class<? extends PsiElement> ... stopAt) {
        if (aClass == null) {
            JsonFacade.$$$reportNull$$$0(64);
        }
        if (stopAt == null) {
            JsonFacade.$$$reportNull$$$0(65);
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)element, aClass, (boolean)strict, (Class[])stopAt);
    }

    @NotNull
    public static <T extends PsiElement> List<T> collectParents(@NotNull PsiElement element, @NotNull Class<? extends T> parent, boolean includeMyself, @NotNull Predicate<? super PsiElement> stopCondition) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(66);
        }
        if (parent == null) {
            JsonFacade.$$$reportNull$$$0(67);
        }
        if (stopCondition == null) {
            JsonFacade.$$$reportNull$$$0(68);
        }
        List list = PsiTreeUtil.collectParents((PsiElement)element, parent, (boolean)includeMyself, stopCondition);
        if (list == null) {
            JsonFacade.$$$reportNull$$$0(69);
        }
        return list;
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element, @NotNull IElementType elementType, @Nullable Consumer<? super PsiElement> consumer) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(70);
        }
        if (elementType == null) {
            JsonFacade.$$$reportNull$$$0(71);
        }
        return PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)elementType, consumer);
    }

    @Nullable
    public static PsiElement findSiblingForward(@NotNull PsiElement element, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<? super PsiElement> consumer) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(72);
        }
        if (elementType == null) {
            JsonFacade.$$$reportNull$$$0(73);
        }
        return PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)elementType, (boolean)strict, consumer);
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element, @NotNull IElementType elementType, @Nullable Consumer<? super PsiElement> consumer) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(74);
        }
        if (elementType == null) {
            JsonFacade.$$$reportNull$$$0(75);
        }
        return PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)elementType, consumer);
    }

    @Nullable
    public static PsiElement findSiblingBackward(@NotNull PsiElement element, @NotNull IElementType elementType, boolean strict, @Nullable Consumer<? super PsiElement> consumer) {
        if (element == null) {
            JsonFacade.$$$reportNull$$$0(76);
        }
        if (elementType == null) {
            JsonFacade.$$$reportNull$$$0(77);
        }
        return PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)elementType, (boolean)strict, consumer);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiElement skipSiblingsForward(@Nullable PsiElement element, Class<? extends PsiElement> ... elementClasses) {
        if (elementClasses == null) {
            JsonFacade.$$$reportNull$$$0(78);
        }
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])elementClasses);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesAndCommentsForward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiElement skipSiblingsBackward(@Nullable PsiElement element, Class<? extends PsiElement> ... elementClasses) {
        if (elementClasses == null) {
            JsonFacade.$$$reportNull$$$0(79);
        }
        return PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])elementClasses);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiElement skipWhitespacesAndCommentsBackward(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiElement skipParentsOfType(@Nullable PsiElement element, Class<? extends PsiElement> ... parentClasses) {
        if (parentClasses == null) {
            JsonFacade.$$$reportNull$$$0(80);
        }
        return PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])parentClasses);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static PsiElement skipMatching(@Nullable PsiElement element, @NotNull Function<? super PsiElement, ? extends PsiElement> next, @NotNull Predicate<? super PsiElement> condition) {
        if (next == null) {
            JsonFacade.$$$reportNull$$$0(81);
        }
        if (condition == null) {
            JsonFacade.$$$reportNull$$$0(82);
        }
        return PsiTreeUtil.skipMatching((PsiElement)element, next, condition);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(83);
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classes);
    }

    @SafeVarargs
    @Contract(value="null, _ -> null")
    @Nullable
    public static <T extends PsiElement> T getNonStrictParentOfType(@Nullable PsiElement element, Class<? extends T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(84);
        }
        return (T)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])classes);
    }

    @Contract(pure=true)
    public static PsiElement[] collectElements(@Nullable PsiElement element, @NotNull PsiElementFilter filter) {
        if (filter == null) {
            JsonFacade.$$$reportNull$$$0(85);
        }
        return PsiTreeUtil.collectElements((PsiElement)element, (PsiElementFilter)filter);
    }

    @SafeVarargs
    @Contract(pure=true)
    @NotNull
    public static <T extends PsiElement> Collection<T> collectElementsOfType(@Nullable PsiElement element, Class<T> ... classes) {
        if (classes == null) {
            JsonFacade.$$$reportNull$$$0(86);
        }
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])classes);
        if (collection == null) {
            JsonFacade.$$$reportNull$$$0(87);
        }
        return collection;
    }

    @Contract(value="null, _, _ -> true")
    public static <T extends PsiElement> boolean processElements(@Nullable PsiElement element, @NotNull Class<T> elementClass, @NotNull PsiElementProcessor<? super T> processor) {
        if (elementClass == null) {
            JsonFacade.$$$reportNull$$$0(88);
        }
        if (processor == null) {
            JsonFacade.$$$reportNull$$$0(89);
        }
        return PsiTreeUtil.processElements((PsiElement)element, elementClass, processor);
    }

    @Contract(value="null, _ -> true")
    public static boolean processElements(@Nullable PsiElement element, @NotNull PsiElementProcessor<? super PsiElement> processor) {
        if (processor == null) {
            JsonFacade.$$$reportNull$$$0(90);
        }
        return PsiTreeUtil.processElements((PsiElement)element, processor);
    }

    public static boolean processElements(@NotNull PsiElementProcessor<? super PsiElement> processor, PsiElement ... elements) {
        if (processor == null) {
            JsonFacade.$$$reportNull$$$0(91);
        }
        return PsiTreeUtil.processElements(processor, (PsiElement[])elements);
    }

    @NotNull
    public static Optional<JsonProperty> getPropertyChildByName(@Nullable JsonObject element, @NotNull String name) {
        if (name == null) {
            JsonFacade.$$$reportNull$$$0(92);
        }
        Optional<JsonProperty> optional = Optional.ofNullable((JsonProperty[])PsiTreeUtil.getChildrenOfType((PsiElement)element, JsonProperty.class)).stream().flatMap(Arrays::stream).filter(property -> name.equals(property.getName())).findFirst();
        if (optional == null) {
            JsonFacade.$$$reportNull$$$0(93);
        }
        return optional;
    }

    public static void safeSetTopLevelPropertyIfChanged(JsonFile jsonFile, String propName, String newValue) {
        JsonObject topLevelObject = JsonFacade.getTopLevelObject(jsonFile);
        JsonStringLiteral valueStringLiteral = JsonFacade.safeGetPropertyValueOfType(topLevelObject, propName, JsonStringLiteral.class);
        String value = JsonFacade.safeGetValueAsString((PsiElement)valueStringLiteral);
        if (Objects.equals(value, newValue)) {
            return;
        }
        Project project = jsonFile.getProject();
        if (valueStringLiteral != null) {
            QuickFixUtils.safeReplaceJsonStringLiteralValueWithText(project, (PsiElement)valueStringLiteral, newValue);
        } else {
            JsonElementGenerator json = new JsonElementGenerator(project);
            JsonProperty nameProperty = json.createProperty(propName, "\"" + newValue + "\"");
            if (topLevelObject != null) {
                if (!topLevelObject.getPropertyList().isEmpty()) {
                    topLevelObject.addBefore((PsiElement)nameProperty, (PsiElement)topLevelObject.getPropertyList().get(0));
                    topLevelObject.addAfter(json.createComma(), (PsiElement)topLevelObject.getPropertyList().get(0));
                } else {
                    topLevelObject.replace((PsiElement)json.createObject(nameProperty.getText()));
                }
            } else {
                jsonFile.add((PsiElement)json.createObject(nameProperty.getText()));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 14, 16, 19, 20, 22, 24, 29, 39, 41, 43, 51, 53, 56, 69, 87, 93 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 5: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 6: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonTag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 30: 
            case 47: 
            case 66: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 29: 
            case 39: 
            case 41: 
            case 43: 
            case 51: 
            case 53: 
            case 56: 
            case 69: 
            case 87: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/JsonFacade";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 21: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 44: 
            case 49: 
            case 52: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 50: 
            case 57: 
            case 83: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 45: 
            case 46: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopCondition";
                break;
            }
            case 71: 
            case 73: 
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClasses";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/JsonFacade";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findFurthestSiblingOfSameType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTextWithoutHostEscaping";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "addProperty";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherSiblingPropertyNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameElement";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenOfType";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "findChildrenOfAnyType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfAnyType";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfTypeAsList";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsOfRange";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "collectElementsOfType";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyChildByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJsonFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValueOfType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "safeGetPropertyValueOfType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getArrayIndexOfItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isArrayElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFurthestSiblingOfSameType";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 29: 
            case 39: 
            case 41: 
            case 43: 
            case 51: 
            case 53: 
            case 56: 
            case 69: 
            case 87: 
            case 93: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElementTextWithoutHostEscaping";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 21: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNameElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findCommonParent";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findChildOfAnyType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfType";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenOfAnyType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfType";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findFirstParent";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "countChildrenOfType";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfAnyType";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfTypeAsList";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOfRange";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingOfType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingOfType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfType";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingForward";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingBackward";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsForward";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsBackward";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "skipParentsOfType";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "skipMatching";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParentOfType";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "collectElements";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "collectElementsOfType";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyChildByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 14, 16, 19, 20, 22, 24, 29, 39, 41, 43, 51, 53, 56, 69, 87, 93 -> new IllegalStateException(string);
        };
    }
}

