/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.json.psi.JsonFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.stream.Stream;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.liveTemplate.PlatformWidgetFieldsContext;

public class FieldLabelTagDependingOnWidgetTypeMacro
extends MacroBase {
    public FieldLabelTagDependingOnWidgetTypeMacro() {
        super("fieldLabelTagDependingOnWidgetType", "fieldLabelTagDependingOnWidgetType()");
    }

    private FieldLabelTagDependingOnWidgetTypeMacro(String name, String description) {
        super(name, description);
    }

    protected Result calculateResult(Expression[] prms, ExpressionContext context, boolean quick) {
        PsiElement psiElementAtStartOffset = context.getPsiElementAtStartOffset();
        if (psiElementAtStartOffset != null) {
            PsiFile containingFile = psiElementAtStartOffset.getContainingFile();
            if (!(containingFile instanceof JsonFile)) {
                return null;
            }
            JsonFile file = (JsonFile)containingFile;
            String widgetType = JWidget.getWidgetType(file);
            if (widgetType != null) {
                if (JWidget.getFormLikeWidgetTypes().stream().anyMatch(widgetType::contains)) {
                    return new TextResult("label");
                }
                if (Stream.of("List").anyMatch(widgetType::contains)) {
                    return new TextResult("title");
                }
            }
        }
        return new TextResult("label");
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof PlatformWidgetFieldsContext;
    }
}

