/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import org.cxbox.intellij.community.icons.PlatformIcons;
import org.cxbox.intellij.community.wigdet.fields.field.generator.AbstractVersionAwareWidgetNewFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.CheckboxFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.DateFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.DateTimeFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.DictionaryEnumFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.FileUploadFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.HiddenOrHintFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.InputFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.MultipleSelectFieldCommaSeparatedGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.MultipleSelectFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.MultivalueFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.NumberOrPercentOrMoneyFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.NumberOrPercentOrMoneyFieldWithDigitsGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.PickListFieldGenerator;
import org.cxbox.intellij.community.wigdet.fields.field.generator.TimeFieldGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StandardFieldType {
    input("input", "widget_field_input/", PlatformIcons.input, List.of(InputFieldGenerator.class)),
    dictionary("dictionary", "widget_field_dictionary/", PlatformIcons.dictionary, List.of(DictionaryEnumFieldGenerator.class)),
    hidden("hidden", "widget_field_hidden/", PlatformIcons.hidden, List.of(HiddenOrHintFieldGenerator.class)),
    text("text", "widget_field_text/", PlatformIcons.text, List.of(InputFieldGenerator.class)),
    date("date", "widget_field_date/", PlatformIcons.date, List.of(DateFieldGenerator.class)),
    time("time", "widget_field_time/", PlatformIcons.time, List.of(TimeFieldGenerator.class)),
    timeWithFormat("timeWithFormat", "widget_field_time/", PlatformIcons.time, List.of(TimeFieldGenerator.class)),
    dateTime("dateTime", "widget_field_dateTime/", PlatformIcons.dateTime, List.of(DateTimeFieldGenerator.class)),
    dateTimeWithSeconds("dateTimeWithSeconds", "widget_field_dateTimeWithSeconds/", PlatformIcons.dateTimeWithSeconds, List.of(DateFieldGenerator.class)),
    number("number", "widget_field_number/", PlatformIcons.number, List.of(NumberOrPercentOrMoneyFieldGenerator.class, NumberOrPercentOrMoneyFieldWithDigitsGenerator.class)),
    money("money", "widget_field_money/", PlatformIcons.money, List.of(NumberOrPercentOrMoneyFieldWithDigitsGenerator.class)),
    percent("percent", "widget_field_percent/", PlatformIcons.percent, List.of(NumberOrPercentOrMoneyFieldGenerator.class, NumberOrPercentOrMoneyFieldWithDigitsGenerator.class)),
    radio("radio", "widget_field_radio/", PlatformIcons.radio, List.of(DictionaryEnumFieldGenerator.class)),
    checkbox("checkbox", "widget_field_checkbox/", PlatformIcons.checkbox, List.of(CheckboxFieldGenerator.class)),
    fileUpload("fileUpload", "widget_field_fileUpload/", PlatformIcons.fileUpload, List.of(FileUploadFieldGenerator.class)),
    pickList("pickList", "widget_field_pickList/", PlatformIcons.pickList, List.of(PickListFieldGenerator.class)),
    inlinePickList("inline-pickList", "widget_field_inlinePickList/", PlatformIcons.inlinePickList, List.of(PickListFieldGenerator.class)),
    suggestionPickList("suggestionPickList", "widget_field_suggestionPickList/", PlatformIcons.suggestionPickList, List.of(PickListFieldGenerator.class)),
    multifield("multifield", "widget_field_multifield/", PlatformIcons.multifield, new ArrayList<Class<? extends AbstractVersionAwareWidgetNewFieldGenerator>>()),
    multivalue("multivalue", "widget_field_multivalue/", PlatformIcons.multivalue, List.of(MultivalueFieldGenerator.class)),
    multipleSelect("multipleSelect", "widget_field_multipleSelect/", PlatformIcons.multipleSelect, List.of(MultipleSelectFieldGenerator.class, MultipleSelectFieldCommaSeparatedGenerator.class)),
    hint("hint", "widget_field_hint/", PlatformIcons.hint, List.of(HiddenOrHintFieldGenerator.class)),
    multivalueHover("multivalueHover", "widget_field_multivalueHover/", PlatformIcons.multivalueHover, List.of(MultivalueFieldGenerator.class));

    public static final String DOC_BASE_URL = "https://doc.cxbox.org/";
    public static final String DOC_BASE_ALT_URL = "http://localhost:8000/";
    private final String templateKeyPrefix;
    private final String documentationRelativeUrl;
    private final Icon icon;
    private final List<Class<? extends AbstractVersionAwareWidgetNewFieldGenerator>> generatorClz;

    private StandardFieldType(@Nullable String templateKeyPrefix, @Nullable String documentationRelativeUrl, Icon icon, List<Class<? extends AbstractVersionAwareWidgetNewFieldGenerator>> generatorClz) {
        if (templateKeyPrefix == null) {
            StandardFieldType.$$$reportNull$$$0(0);
        }
        if (documentationRelativeUrl == null) {
            StandardFieldType.$$$reportNull$$$0(1);
        }
        this.templateKeyPrefix = templateKeyPrefix;
        this.documentationRelativeUrl = documentationRelativeUrl;
        this.icon = icon;
        this.generatorClz = generatorClz;
    }

    @NotNull
    public static Optional<StandardFieldType> getByFieldType(@NotNull String fieldType) {
        if (fieldType == null) {
            StandardFieldType.$$$reportNull$$$0(2);
        }
        Optional<StandardFieldType> optional = Arrays.stream(StandardFieldType.values()).filter(t -> fieldType.equals(t.getJ2eeTemplateKeyPrefix())).findFirst();
        if (optional == null) {
            StandardFieldType.$$$reportNull$$$0(3);
        }
        return optional;
    }

    public static List<Class<? extends AbstractVersionAwareWidgetNewFieldGenerator>> getGeneratorClz(@NotNull StandardFieldType entry) {
        if (entry == null) {
            StandardFieldType.$$$reportNull$$$0(4);
        }
        return entry.generatorClz;
    }

    public String getDocumentationUrl() {
        return DOC_BASE_URL + this.documentationRelativeUrl;
    }

    public String getAlternativeDocumentationUrl() {
        return DOC_BASE_ALT_URL + this.documentationRelativeUrl;
    }

    public String getJ2eeTemplateKeyPrefix() {
        return this.templateKeyPrefix;
    }

    public Icon getIcon() {
        return this.icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateKeyPrefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationRelativeUrl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/wigdet/fields/StandardFieldType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/StandardFieldType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getByFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getByFieldType";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorClz";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

