/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.view.url;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.intellij.community.common.conf.JScreen;
import org.cxbox.intellij.community.common.conf.JView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewUrlReferenceProvider
extends PsiReferenceProvider {
    public ViewUrlReferenceProvider(boolean isSchemaProperty) {
    }

    private static void addViewUrlViewPartRefs(@NotNull PsiElement element, List<PsiReference> refs, String value, Project project) {
        Module module;
        if (element == null) {
            ViewUrlReferenceProvider.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        String keyword = "/view/";
        int keyWordIndex = value.indexOf(keyword);
        if (keyWordIndex != -1) {
            String view = ("\"" + value + "\"").substring(1 + keyWordIndex + keyword.length(), value.length() + 1);
            Pair<Optional<? extends PsiNamedElement>, List<JView.ViewLookupItem>> pair = JView.getLinkAndAutocompletionByViewName(view, project, module);
            List<LookupElement> collect = ((List)pair.getSecond()).stream().map(JView.ViewLookupItem::mapToLookupElement).collect(Collectors.toList());
            refs.add((PsiReference)new JsonValueToJsonValueReferenceLink(element, new TextRange(1 + keyWordIndex + keyword.length(), value.length() + 1), ((Optional)pair.getFirst()).orElse(null), collect));
        }
    }

    private static void addViewUrlScreenPartRefs(@NotNull PsiElement element, List<PsiReference> refs, String value, Project project) {
        Module module;
        if (element == null) {
            ViewUrlReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        String keyword = "/screen/";
        int keyWordIndex = value.indexOf(keyword);
        if (keyWordIndex != -1) {
            int end = StringUtils.indexOf((CharSequence)value, (CharSequence)"/", (int)(keyWordIndex + keyword.length()));
            if (end == -1) {
                end = value.length();
            }
            String screen = ("\"" + value + "\"").substring(1 + keyWordIndex + keyword.length(), end + 1);
            Pair<Optional<? extends PsiNamedElement>, List<String>> pair = JScreen.getLinkAndAutocompletionByViewName(screen, project, module);
            refs.add((PsiReference)new JsonValueToJsonValueReferenceLink2(element, new TextRange(1 + keyWordIndex + keyword.length(), end + 1), ((Optional)pair.getFirst()).orElse(null), (List)pair.getSecond()));
        }
    }

    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            ViewUrlReferenceProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ViewUrlReferenceProvider.$$$reportNull$$$0(3);
        }
        if (!(element instanceof JsonStringLiteral)) {
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        String originalText = element.getText();
        String value = originalText.replaceAll("\"", "");
        Project project = element.getProject();
        ViewUrlReferenceProvider.addViewUrlViewPartRefs(element, refs, value, project);
        ViewUrlReferenceProvider.addViewUrlScreenPartRefs(element, refs, value, project);
        return refs.size() == 0 ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(refs, PsiReference[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/view/url/ViewUrlReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addViewUrlViewPartRefs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addViewUrlScreenPartRefs";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencesByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JsonValueToJsonValueReferenceLink
    extends PsiReferenceBase<PsiElement> {
        final PsiElement resolve;
        final List<LookupElement> variants;

        public JsonValueToJsonValueReferenceLink(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @Nullable PsiElement resolve, @NotNull List<LookupElement> variants) {
            if (element == null) {
                JsonValueToJsonValueReferenceLink.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                JsonValueToJsonValueReferenceLink.$$$reportNull$$$0(1);
            }
            if (variants == null) {
                JsonValueToJsonValueReferenceLink.$$$reportNull$$$0(2);
            }
            super(element, rangeInElement, true);
            this.resolve = resolve;
            this.variants = variants;
        }

        @Nullable
        public PsiElement resolve() {
            return this.resolve;
        }

        public Object[] getVariants() {
            return this.variants.toArray();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variants";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/view/url/ViewUrlReferenceProvider$JsonValueToJsonValueReferenceLink";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class JsonValueToJsonValueReferenceLink2
    extends PsiReferenceBase<PsiElement> {
        final PsiElement resolve;
        final List<String> variants;

        public JsonValueToJsonValueReferenceLink2(@NotNull PsiElement element, @NotNull TextRange rangeInElement, @Nullable PsiElement resolve, @NotNull List<String> variants) {
            if (element == null) {
                JsonValueToJsonValueReferenceLink2.$$$reportNull$$$0(0);
            }
            if (rangeInElement == null) {
                JsonValueToJsonValueReferenceLink2.$$$reportNull$$$0(1);
            }
            if (variants == null) {
                JsonValueToJsonValueReferenceLink2.$$$reportNull$$$0(2);
            }
            super(element, rangeInElement, true);
            this.resolve = resolve;
            this.variants = variants;
        }

        @Nullable
        public PsiElement resolve() {
            return this.resolve;
        }

        public Object[] getVariants() {
            return this.variants.toArray();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variants";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/view/url/ViewUrlReferenceProvider$JsonValueToJsonValueReferenceLink2";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

