/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.awt.MouseInfo;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.fields.StandardFieldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFacade {
    private static final List<String> COLLECTIONS_AND_MAP_QUALIFIED_NAME = List.of("java.util.Map", "java.util.Collection", "java.util.List", "java.util.Set");
    private static final Map<String, String> MAP_OF_PRIMITIVE_TYPES = Map.of("long", Long.class.getCanonicalName(), "int", Integer.class.getCanonicalName(), "short", Short.class.getCanonicalName(), "byte", Byte.class.getCanonicalName(), "double", Double.class.getCanonicalName(), "float", Float.class.getCanonicalName(), "boolean", Boolean.class.getCanonicalName(), "char", Character.class.getCanonicalName());
    public static final String MAP = "java.util.Map";

    private JavaFacade() {
    }

    @Nullable
    public static <T extends PsiElement> T getSafeParent(@Nullable PsiElement element, @NotNull Class<T> aClass) {
        if (aClass == null) {
            JavaFacade.$$$reportNull$$$0(0);
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        if (aClass.isInstance(parent)) {
            return (T)((PsiElement)aClass.cast(parent));
        }
        return null;
    }

    @NotNull
    public static Boolean hasAnnotations(@Nullable PsiField field, String ... annotationFQNs) {
        if (field == null || Objects.isNull(annotationFQNs)) {
            Boolean bl = false;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(1);
            }
            return bl;
        }
        for (String fqn : annotationFQNs) {
            if (fqn == null || !field.hasAnnotation(fqn)) continue;
            Boolean bl = true;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(2);
            }
            return bl;
        }
        Boolean bl = false;
        if (bl == null) {
            JavaFacade.$$$reportNull$$$0(3);
        }
        return bl;
    }

    @NotNull
    public static Boolean isEntity(@Nullable PsiClass entityClass, @NotNull Module module) {
        if (module == null) {
            JavaFacade.$$$reportNull$$$0(4);
        }
        if (Objects.isNull(entityClass)) {
            Boolean bl = false;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(5);
            }
            return bl;
        }
        String persistenceVersion = Cache.getPersistenceVersionWithoutDot(entityClass.getProject(), module);
        Boolean bl = entityClass.hasAnnotation(persistenceVersion + ".Entity");
        if (bl == null) {
            JavaFacade.$$$reportNull$$$0(6);
        }
        return bl;
    }

    @NotNull
    public static Boolean isEmbedded(@Nullable PsiClass entityClass, @NotNull Module module) {
        if (module == null) {
            JavaFacade.$$$reportNull$$$0(7);
        }
        if (Objects.isNull(entityClass)) {
            Boolean bl = false;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(8);
            }
            return bl;
        }
        String persistenceVersion = Cache.getPersistenceVersionWithoutDot(entityClass.getProject(), module);
        Boolean bl = entityClass.hasAnnotation(persistenceVersion + ".Embedded");
        if (bl == null) {
            JavaFacade.$$$reportNull$$$0(9);
        }
        return bl;
    }

    @Nullable
    public static PsiClass getClassByField(@Nullable PsiField field) {
        if (field == null) {
            return null;
        }
        return PsiUtil.resolveClassInClassTypeOnly((PsiType)field.getType());
    }

    @NotNull
    public static Optional<PsiType> getTypeFromGeneric(@Nullable PsiType type, @NotNull Integer genericIndex) {
        if (genericIndex == null) {
            JavaFacade.$$$reportNull$$$0(10);
        }
        if (Objects.isNull(type)) {
            Optional<PsiType> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(11);
            }
            return optional;
        }
        if (type instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)type;
            return JavaFacade.getGenericType(psiClassType, genericIndex);
        }
        Optional<PsiType> optional = Optional.empty();
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(12);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getClassFromGeneric(@Nullable PsiField field, @NotNull Integer genericIndex) {
        if (genericIndex == null) {
            JavaFacade.$$$reportNull$$$0(13);
        }
        if (Objects.isNull(field) || Objects.isNull(field.getContainingClass())) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(14);
            }
            return optional;
        }
        PsiType psiType = field.getType();
        if (psiType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            return JavaFacade.getGenericClass(psiClassType, genericIndex);
        }
        Optional<PsiClass> optional = Optional.empty();
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(15);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiType> getTypeFromGenericLast(@Nullable PsiType type) {
        if (Objects.isNull(type)) {
            Optional<PsiType> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(16);
            }
            return optional;
        }
        if (type instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)type;
            return JavaFacade.getGenericType(psiClassType, psiClassType.getParameters().length - 1);
        }
        Optional<PsiType> optional = Optional.empty();
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(17);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiClass> getGenericClass(@NotNull PsiClassType classType, @NotNull Integer genericIndex) {
        PsiType psiType;
        PsiType[] genericTypes;
        if (classType == null) {
            JavaFacade.$$$reportNull$$$0(18);
        }
        if (genericIndex == null) {
            JavaFacade.$$$reportNull$$$0(19);
        }
        if ((genericTypes = classType.getParameters()).length > 0 && (psiType = genericTypes[genericTypes.length - 1]) instanceof PsiClassType) {
            PsiClassType newClassType = (PsiClassType)psiType;
            Optional<PsiClass> optional = Optional.ofNullable(newClassType.resolve());
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(20);
            }
            return optional;
        }
        Optional<PsiClass> optional = Optional.empty();
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(21);
        }
        return optional;
    }

    @NotNull
    private static Optional<PsiType> getGenericType(@NotNull PsiClassType classType, @NotNull Integer genericIndex) {
        PsiType[] genericTypes;
        if (classType == null) {
            JavaFacade.$$$reportNull$$$0(22);
        }
        if (genericIndex == null) {
            JavaFacade.$$$reportNull$$$0(23);
        }
        if ((genericTypes = classType.getParameters()).length > 0 && genericTypes.length >= genericIndex) {
            Optional<PsiType> optional = Optional.ofNullable(genericTypes[genericIndex]);
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(24);
            }
            return optional;
        }
        Optional<PsiType> optional = Optional.empty();
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(25);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getClassFromGenericLast(@Nullable PsiField field) {
        if (Objects.isNull(field) || Objects.isNull(field.getContainingClass())) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(26);
            }
            return optional;
        }
        PsiType psiType = field.getType();
        if (psiType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)psiType;
            return JavaFacade.getGenericClass(psiClassType, psiClassType.getParameters().length - 1);
        }
        Optional<PsiClass> optional = Optional.empty();
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(27);
        }
        return optional;
    }

    @NotNull
    public static Optional<PsiClass> getClassConstructorFirstArgClassOrNull(@NotNull PsiElement context) {
        PsiClass dtoClass;
        if (context == null) {
            JavaFacade.$$$reportNull$$$0(28);
        }
        if ((dtoClass = PsiUtil.getTopLevelClass((PsiElement)context)) == null) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(29);
            }
            return optional;
        }
        PsiMethod[] constructors = dtoClass.getConstructors();
        if (constructors.length == 0) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(30);
            }
            return optional;
        }
        PsiMethod constructor = constructors[0];
        PsiParameterList parameterList = constructor.getParameterList();
        if (parameterList.isEmpty()) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(31);
            }
            return optional;
        }
        PsiParameter parameter = parameterList.getParameter(0);
        if (parameter == null) {
            Optional<PsiClass> optional = Optional.empty();
            if (optional == null) {
                JavaFacade.$$$reportNull$$$0(32);
            }
            return optional;
        }
        PsiType type = parameter.getType();
        Optional<PsiClass> optional = Optional.ofNullable(PsiUtil.resolveClassInClassTypeOnly((PsiType)type));
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(33);
        }
        return optional;
    }

    @NotNull
    public static Boolean isFieldCollectionWithGenericEntityOrEmbeddable(@Nullable PsiField field, @NotNull Module module) {
        if (module == null) {
            JavaFacade.$$$reportNull$$$0(34);
        }
        if (field == null) {
            Boolean bl = false;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(35);
            }
            return bl;
        }
        if (!(field.getType() instanceof PsiClassType)) {
            Boolean bl = false;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(36);
            }
            return bl;
        }
        PsiClass psiClass = ((PsiClassType)field.getType()).resolve();
        if (psiClass == null || psiClass.getQualifiedName() == null || !JavaFacade.hasCollectionAsSuperClass(psiClass)) {
            Boolean bl = false;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(37);
            }
            return bl;
        }
        PsiClass genericClass = JavaFacade.getClassFromGenericLast(field).orElse(null);
        if (genericClass == null) {
            Boolean bl = false;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(38);
            }
            return bl;
        }
        if (!(genericClass instanceof PsiClassType)) {
            Boolean bl = true;
            if (bl == null) {
                JavaFacade.$$$reportNull$$$0(39);
            }
            return bl;
        }
        PsiClassType psiClassType = (PsiClassType)genericClass;
        PsiClass psiClass1 = psiClassType.resolve();
        Boolean bl = psiClass1 != null && (JavaFacade.isEntity(psiClass1, module) != false || JavaFacade.isEmbedded(psiClass1, module) != false);
        if (bl == null) {
            JavaFacade.$$$reportNull$$$0(40);
        }
        return bl;
    }

    @NotNull
    public static Boolean isMultiValueField(@NotNull String pkg, @NotNull PsiField field) {
        if (pkg == null) {
            JavaFacade.$$$reportNull$$$0(41);
        }
        if (field == null) {
            JavaFacade.$$$reportNull$$$0(42);
        }
        Boolean bl = field.getType().getCanonicalText().equalsIgnoreCase(pkg + ".core.dto.multivalue.MultivalueField");
        if (bl == null) {
            JavaFacade.$$$reportNull$$$0(43);
        }
        return bl;
    }

    private static boolean hasCollectionAsSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFacade.$$$reportNull$$$0(44);
        }
        if (JavaFacade.isCollection(psiClass)) {
            return true;
        }
        return Arrays.stream(psiClass.getSupers()).filter(Objects::nonNull).map(PsiClass::getQualifiedName).anyMatch(COLLECTIONS_AND_MAP_QUALIFIED_NAME::contains);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static void withPrettyExceptionAndRethrow(Runnable runnable) throws Throwable {
        block2: {
            try {
                runnable.run();
            }
            catch (PlatformValidationException e) {
                e.showPopupWithLinks();
                if (e.getOrigException() == null) break block2;
                throw e.getOrigException();
            }
        }
    }

    public static void withPrettyException(@NotNull Project prj, @Nullable String nonPlatformExceptionText, @NotNull Runnable runnable) {
        if (prj == null) {
            JavaFacade.$$$reportNull$$$0(45);
        }
        if (runnable == null) {
            JavaFacade.$$$reportNull$$$0(46);
        }
        try {
            runnable.run();
        }
        catch (PlatformValidationException e) {
            e.showPopupWithLinks();
        }
        catch (Exception e) {
            new PlatformValidationException(Optional.ofNullable(nonPlatformExceptionText).orElse("Operation was not finished successfully"), null, e, prj).showPopupWithLinks();
        }
    }

    public static String toUrlParamFriendly(@NotNull String input) {
        if (input == null) {
            JavaFacade.$$$reportNull$$$0(47);
        }
        StringBuilder result = new StringBuilder();
        input.chars().mapToObj(c -> String.valueOf((char)c)).filter(c -> Objects.equals(URLEncoder.encode(c, StandardCharsets.UTF_8), c)).forEach(result::append);
        return result.toString();
    }

    public static String toHumanText(String origText) {
        return NameUtil.splitWords((String)origText, (char)' ', Strings::capitalize).trim();
    }

    public static String convertToJavaIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return "_";
        }
        StringBuilder javaIdentifier = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char letter = name.charAt(i);
            if (javaIdentifier.isEmpty()) {
                if (!Character.isLetter(letter)) continue;
                javaIdentifier.append(Character.toLowerCase(letter));
                continue;
            }
            if (!Character.isLetterOrDigit(letter)) continue;
            javaIdentifier.append(letter);
        }
        return javaIdentifier.toString();
    }

    public static String removeBuckets(String name) {
        if (name == null || name.isEmpty()) {
            return "_";
        }
        if (name.startsWith("\"")) {
            name = name.substring(1);
        }
        if (name.endsWith("\"")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static void showSuccessNotification(Project project, String html) {
        Balloon popup = new PopupFactoryImpl().createHtmlTextBalloonBuilder(html, MessageType.INFO, event -> {}).setHideOnLinkClick(true).createBalloon();
        JavaFacade.showPopup(popup, project);
    }

    public static void showPopup(Balloon popup, Project project) {
        if (MouseInfo.getPointerInfo().getLocation() != null) {
            popup.show(new RelativePoint(MouseInfo.getPointerInfo().getLocation()), Balloon.Position.atRight);
        }
        popup.showInCenterOf((JComponent)Optional.ofNullable(WindowManager.getInstance().getFrame(project)).map(JFrame::getRootPane).orElse(null));
    }

    public static String convertToCamelCase(String value) {
        return NameUtil.splitWords((String)value, (char)' ', word -> word.replaceFirst(String.valueOf(word.charAt(0)), String.valueOf(Strings.toUpperCase((char)word.charAt(0)))));
    }

    @NotNull
    public static Optional<StandardFieldType> getByTemplateKey(@NotNull String templateKey) {
        if (templateKey == null) {
            JavaFacade.$$$reportNull$$$0(48);
        }
        String TEMPLATE_PREFIX_SEPARATOR = " ";
        Optional<StandardFieldType> optional = Arrays.stream(StandardFieldType.values()).filter(t -> templateKey.startsWith(t.getJ2eeTemplateKeyPrefix() + " ") || templateKey.equals(t.getJ2eeTemplateKeyPrefix())).findFirst();
        if (optional == null) {
            JavaFacade.$$$reportNull$$$0(49);
        }
        return optional;
    }

    public static String castPrimitiveToObject(String primitiveType) {
        return MAP_OF_PRIMITIVE_TYPES.getOrDefault(primitiveType, "");
    }

    public static boolean isPrimitiveType(String primitiveType) {
        return MAP_OF_PRIMITIVE_TYPES.containsKey(primitiveType);
    }

    private static boolean isCollection(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFacade.$$$reportNull$$$0(50);
        }
        return psiClass.getQualifiedName() != null && COLLECTIONS_AND_MAP_QUALIFIED_NAME.contains(psiClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 8, 9, 11, 12, 14, 15, 16, 17, 20, 21, 24, 25, 26, 27, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 43, 49 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/util/JavaFacade";
                break;
            }
            case 4: 
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 13: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericIndex";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prj";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/util/JavaFacade";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "hasAnnotations";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isEntity";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isEmbedded";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromGeneric";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFromGeneric";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromGenericLast";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFromGenericLast";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassConstructorFirstArgClassOrNull";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "isFieldCollectionWithGenericEntityOrEmbeddable";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "isMultiValueField";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getByTemplateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSafeParent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 49: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEntity";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEmbedded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromGeneric";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClassFromGeneric";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getGenericClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getGenericType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getClassConstructorFirstArgClassOrNull";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFieldCollectionWithGenericEntityOrEmbeddable";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isMultiValueField";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "hasCollectionAsSuperClass";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "withPrettyException";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "toUrlParamFriendly";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getByTemplateKey";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isCollection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 8, 9, 11, 12, 14, 15, 16, 17, 20, 21, 24, 25, 26, 27, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 43, 49 -> new IllegalStateException(string);
        };
    }
}

