/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.service.generator.versionaware;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiQualifiedNamedElement;
import java.util.List;
import java.util.Optional;
import org.cxbox.intellij.community.common.Cache;
import org.cxbox.intellij.community.common.util.ClassCommon;
import org.cxbox.intellij.community.common.util.FieldWithAnnotation;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.exception.PlatformValidationException;
import org.cxbox.intellij.community.wigdet.bc.service.TemplateProperties;
import org.cxbox.intellij.community.wigdet.bc.service.generator.AbstractBcServicePsiElementGenerator;
import org.cxbox.intellij.community.wigdet.bc.service.generator.ElementGenerationContext;

public class VersionAwareEntityGeneratorBc
extends AbstractBcServicePsiElementGenerator {
    @Override
    public void setCustomProperties(ElementGenerationContext context) {
        context.properties().setProperty(TemplateProperties.ENTITY_FQN.name(), context.bcDialogCreationData().entityClzName());
        context.properties().setProperty(TemplateProperties.ENTITY_NAME.name(), JavaUtil.capitalizeFirstLetter(context.bcDialogCreationData().entityClzName()));
        context.properties().setProperty(TemplateProperties.TABLE_NAME.name(), JavaUtil.toUpperSnakeCase(context.bcDialogCreationData().entityClzName()));
        context.properties().setProperty(TemplateProperties.FILE_TEMPLATE_NAME.name(), "PlatformVersionAwareBaseEntity.java");
        context.properties().setProperty(TemplateProperties.FILE_NAME.name(), context.properties().getProperty(TemplateProperties.ENTITY_NAME.name()) + ".java");
        context.properties().setProperty(TemplateProperties.PACKAGE_NAME.name(), context.properties().getProperty(TemplateProperties.ENTITY_PACKAGE.name()));
        Optional.ofNullable(context.elementBcData().parentBcEnum()).ifPresent(pbc -> {
            ResponseServiceUtils.ResponseServiceData responseServiceDataByBc = ResponseServiceUtils.getResponseServiceDataByBc(context.module().getProject(), context.module(), pbc);
            context.properties().setProperty(TemplateProperties.PARENT_ENTITY_FQN.name(), Optional.ofNullable(responseServiceDataByBc).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiClass::getQualifiedName).orElse(null));
            context.properties().setProperty(TemplateProperties.PARENT_ENTITY_NAME.name(), Optional.ofNullable(responseServiceDataByBc).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiQualifiedNamedElement::getName).map(JavaUtil::deCapitalizeFirstLetter).orElse(null));
            context.properties().setProperty(TemplateProperties.PARENT_ENTITY_TABLE.name(), Optional.ofNullable(responseServiceDataByBc).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiQualifiedNamedElement::getName).map(JavaUtil::toUpperSnakeCase).orElse(null));
        });
    }

    @Override
    public PsiElement getterElement(ElementGenerationContext context) {
        return context.elementBcData().entityClz();
    }

    @Override
    public void setterElement(ElementGenerationContext context, PsiElement element) {
        if (!(element instanceof PsiClass)) {
            throw new PlatformValidationException("Generate not available", null, new IllegalStateException("Incorrect element type, expected class, actual: " + String.valueOf(element)), context.module().getProject(), MessageType.INFO, AllIcons.General.Warning);
        }
        PsiClass psiClass = (PsiClass)element;
        context.elementBcData().setEntityClz(psiClass);
    }

    @Override
    public PsiElement updateElement(ElementGenerationContext context) {
        Optional.ofNullable(context.elementBcData().parentBcEnum()).ifPresent(pbc -> WriteCommandAction.runWriteCommandAction((Project)context.module().getProject(), () -> {
            ResponseServiceUtils.ResponseServiceData responseServiceDataByBc = ResponseServiceUtils.getResponseServiceDataByBc(context.module().getProject(), context.module(), pbc);
            context.properties().setProperty(TemplateProperties.PARENT_ENTITY_FQN.name(), Optional.ofNullable(responseServiceDataByBc).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiClass::getQualifiedName).orElse(null));
            context.properties().setProperty(TemplateProperties.PARENT_ENTITY_NAME.name(), Optional.ofNullable(responseServiceDataByBc).map(ResponseServiceUtils.ResponseServiceData::responseServiceEntityPsiClass).map(PsiQualifiedNamedElement::getName).map(JavaUtil::deCapitalizeFirstLetter).orElse(null));
            PsiClass psiClass = context.elementBcData().entityClz();
            FieldWithAnnotation fieldWithAnnotation = new FieldWithAnnotation();
            String persistenceVersionWithoutDot = Cache.getPersistenceVersionWithoutDot(context.module().getProject(), context.module());
            if (Boolean.parseBoolean(context.properties().getProperty(TemplateProperties.PARENT_VERSION_AWARE_CLASS.name()))) {
                fieldWithAnnotation.setAnnotations(List.of("@" + persistenceVersionWithoutDot + ".ManyToOne", "@" + persistenceVersionWithoutDot + ".JoinColumn(name= \"" + context.properties().getProperty(TemplateProperties.PARENT_ENTITY_TABLE.name()) + "_ID\")"));
                fieldWithAnnotation.setField("private " + context.properties().getProperty(TemplateProperties.PARENT_ENTITY_FQN.name()) + " " + context.properties().getProperty(TemplateProperties.PARENT_ENTITY_NAME.name()) + ";");
                ClassCommon.addFieldWithAnnotaions(context.module().getProject(), psiClass, List.of(fieldWithAnnotation));
            } else {
                fieldWithAnnotation.setAnnotations(List.of());
                fieldWithAnnotation.setField("private String " + context.properties().getProperty(TemplateProperties.PARENT_ENTITY_NAME.name()) + "Id;");
                ClassCommon.addFieldWithAnnotaions(context.module().getProject(), psiClass, List.of(fieldWithAnnotation));
            }
        }));
        return null;
    }
}

