/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.wigdet.bc.BCInspection;
import org.cxbox.intellij.community.wigdet.bc.common.ResponseServiceType;
import org.cxbox.intellij.community.wigdet.bc.common.UiNamedComponent;
import org.cxbox.intellij.community.wigdet.bc.service.ElementPostfix;
import org.cxbox.intellij.community.wigdet.bc.service.generator.BcDialogCreationData;
import org.cxbox.intellij.community.wigdet.bc.ui.RelationshipEntityType;
import org.cxbox.intellij.community.wigdet.bc.ui.component.EnumComboBox;
import org.cxbox.intellij.community.wigdet.bc.ui.component.PanelWithTextAndInputAndSuggestion;
import org.cxbox.intellij.community.wigdet.bc.ui.component.PsiEnumConstantComboBox;

public class BcCreationDialogWrapper
extends DialogWrapper {
    private final Project project;
    private final Module module;
    private final String name;
    private final Map<UiNamedComponent, JComponent> panel = new ConcurrentHashMap<UiNamedComponent, JComponent>();
    private final Map<UiNamedComponent, PanelWithTextAndInputAndSuggestion> fields = new ConcurrentHashMap<UiNamedComponent, PanelWithTextAndInputAndSuggestion>();

    public BcCreationDialogWrapper(Project project, Module module, String name, BCInspection.FixWithCreationBc.BcCreationMetaData data) {
        super(project, true);
        this.project = project;
        this.module = module;
        this.name = name;
        this.setTitle("Create bc: " + name);
        this.panel.put(Panel.MAIN, (JComponent)new JBPanel());
        this.panel.put(Panel.BC_CREATION, (JComponent)new JBPanel());
        this.panel.put(Panel.BC_PARENT, (JComponent)new JBPanel());
        this.createAndAddToPanelFields(data);
        this.addFieldsListeners();
        this.panel.get(Panel.MAIN).add(this.fields.get(Fields.TYPE_SERVICE));
        this.panel.get(Panel.MAIN).add(this.panel.get(Panel.BC_CREATION));
        this.panel.get(Panel.MAIN).add(Box.createVerticalStrut(5));
        this.panel.get(Panel.MAIN).add(new JSeparator(0));
        this.panel.get(Panel.MAIN).add(Box.createVerticalStrut(5));
        this.panel.get(Panel.MAIN).add(this.panel.get(Panel.BC_PARENT));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.panel.get(Panel.MAIN).setLayout(new BoxLayout(this.panel.get(Panel.MAIN), 1));
        this.panel.get(Panel.BC_CREATION).setLayout(new BoxLayout(this.panel.get(Panel.BC_CREATION), 1));
        this.panel.get(Panel.BC_PARENT).setLayout(new BoxLayout(this.panel.get(Panel.BC_PARENT), 1));
        this.drawPanel(Panel.BC_CREATION, (ResponseServiceType)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(EnumComboBox.class).getSelectedItem());
        this.drawPanel(Panel.BC_PARENT, (ResponseServiceType)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(EnumComboBox.class).getSelectedItem());
        return this.panel.get(Panel.MAIN);
    }

    public void createAndAddToPanelFields(BCInspection.FixWithCreationBc.BcCreationMetaData data) {
        String nameCapitalized = JavaUtil.capitalizeFirstLetter(this.name);
        for (Fields field : Fields.values()) {
            PanelWithTextAndInputAndSuggestion panelWithLabelNameAndInputFieldAndLabelHelper = new PanelWithTextAndInputAndSuggestion((JLabel)field.nameSupplier().get(), field.providerSupplier().apply(data, nameCapitalized), (JLabel)field.labelSupplier().get());
            panelWithLabelNameAndInputFieldAndLabelHelper.setVisible(field.isVisible());
            this.fields.put(field, panelWithLabelNameAndInputFieldAndLabelHelper);
        }
    }

    private void addFieldsListeners() {
        ((JTextComponent)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.typeServiceChange(), e -> this.parentBcChange(), e -> this.serviceVersionAwareFieldChange(), e -> this.serviceAnySourceFieldChange(), e -> this.dtoVersionAwareFieldChange(), e -> this.dtoAnySourceFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.serviceVersionAwareFieldChange(), e -> this.dtoVersionAwareFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.dtoVersionAwareFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.serviceAnySourceFieldChange(), e -> this.dtoAnySourceFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.dtoAnySourceFieldChange()), this.module));
        ((JTextComponent)this.fields.get(Fields.PARENT_BC).getTypedInputElement(ComboBox.class).getEditor().getEditorComponent()).getDocument().addDocumentListener(BcCreationDialogWrapper.createDocumentListener(List.of(e -> this.parentBcChange()), this.module));
    }

    private static DocumentListener createDocumentListener(final Collection<Consumer<DocumentEvent>> handlers, final Module module) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                1.registerListener(handlers, module, e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                1.registerListener(handlers, module, e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                1.registerListener(handlers, module, e);
            }

            private static void registerListener(Collection<Consumer<DocumentEvent>> handlers2, Module module2, DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> ReadAction.nonBlocking(() -> {
                    handlers2.forEach(h -> h.accept(e));
                    return null;
                }).inSmartMode(module2.getProject()).withDocumentsCommitted(module2.getProject()).submit((Executor)AppExecutorUtil.getAppExecutorService()));
            }
        };
    }

    private void dtoAnySourceFieldChange() {
        PsiClass dataPsi;
        ComboBox dto = (ComboBox)this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement();
        Object data = dto.getSelectedItem();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement();
        String input = Optional.of(dto).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        if (data instanceof PsiClass && (dataPsi = (PsiClass)data).getName() != null && String.valueOf(dataPsi).equals(input)) {
            entityField.setSelectedItem(data);
        } else {
            entityField.setSelectedItem((Object)input);
        }
    }

    private void serviceAnySourceFieldChange() {
        PsiClass selectedItemPsiClass;
        ComboBox serviceName = (ComboBox)this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement();
        ComboBox dtoField = (ComboBox)this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement();
        Object selectedItem = serviceName.getSelectedItem();
        String input = Optional.of(serviceName).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        ResponseServiceUtils.ResponseServiceData responseServiceData = selectedItem instanceof PsiClass && (selectedItemPsiClass = (PsiClass)selectedItem).getName() != null && String.valueOf(selectedItem).equals(input) ? ResponseServiceUtils.getResponseServiceData(selectedItemPsiClass, this.module) : ResponseServiceUtils.getResponseServiceDataByClassName(this.project, this.module, String.valueOf(input));
        if (responseServiceData != null) {
            entityField.setSelectedItem((Object)responseServiceData.responseServiceEntityPsiClass());
            dtoField.setSelectedItem((Object)responseServiceData.responseServiceDtoPsiClass());
            dtoField.setEnabled(false);
        } else {
            dtoField.setEnabled(true);
        }
    }

    private void parentBcChange() {
        PsiEnumConstant psiEnumConstant = (PsiEnumConstant)this.fields.get(Fields.PARENT_BC).getTypedInputElement(ComboBox.class).getSelectedItem();
        this.fields.get(Fields.TYPE_RELATIONSHIP).setVisible(false);
        boolean isVersionAwareService = false;
        Optional<PsiClass> parentServiceClass = Optional.ofNullable(ResponseServiceUtils.getResponseServiceDataByBc(this.project, this.module, psiEnumConstant)).map(ResponseServiceUtils.ResponseServiceData::responseServicePsiClass);
        if (parentServiceClass.isPresent()) {
            isVersionAwareService = ResponseServiceUtils.isVersionAwareResponseService(parentServiceClass.get(), this.project, this.module);
        }
        if (psiEnumConstant != null && isVersionAwareService) {
            this.fields.get(Fields.TYPE_RELATIONSHIP).setVisible(true);
        }
    }

    private void typeServiceChange() {
        Object selectedItem = this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(ComboBox.class).getSelectedItem();
        if (selectedItem instanceof ResponseServiceType) {
            ResponseServiceType responseServiceType = (ResponseServiceType)selectedItem;
            this.drawPanel(Panel.BC_CREATION, responseServiceType);
            if (responseServiceType.equals(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE)) {
                ((JComponent)this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement()).setEnabled(false);
                this.fields.get(Fields.ENTITY_ANY_SOURCE).getTypedInputElement(ComboBox.class).setSelectedItem(this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getSelectedItem());
            }
            this.drawPanel(Panel.BC_PARENT, responseServiceType);
        }
    }

    private void serviceVersionAwareFieldChange() {
        PsiClass selectedItemPsiClass;
        ComboBox serviceName = (ComboBox)this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement();
        ComboBox dtoField = (ComboBox)this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement();
        dtoField.setEnabled(false);
        entityField.setEnabled(false);
        Object selectedItem = serviceName.getSelectedItem();
        String input = Optional.of(serviceName).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        ResponseServiceUtils.ResponseServiceData responseServiceData = selectedItem instanceof PsiClass && (selectedItemPsiClass = (PsiClass)selectedItem).getName() != null && String.valueOf(selectedItemPsiClass).equals(input) ? ResponseServiceUtils.getResponseServiceData(selectedItemPsiClass, this.module) : ResponseServiceUtils.getResponseServiceDataByClassName(this.project, this.module, String.valueOf(input));
        if (responseServiceData != null) {
            entityField.setSelectedItem((Object)responseServiceData.responseServiceEntityPsiClass());
            dtoField.setSelectedItem((Object)responseServiceData.responseServiceDtoPsiClass());
            dtoField.setEnabled(false);
            entityField.setEnabled(false);
        } else {
            dtoField.setEnabled(true);
            entityField.setEnabled(true);
        }
    }

    private void dtoVersionAwareFieldChange() {
        PsiClass dtoPsi;
        ComboBox dto = (ComboBox)this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement();
        ComboBox entityField = (ComboBox)this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement();
        entityField.setEnabled(false);
        Object selectedItem = dto.getSelectedItem();
        String input = Optional.of(dto).map(JComboBox::getEditor).map(ComboBoxEditor::getItem).map(String::valueOf).orElse(null);
        PsiClass dtoPsiClass = selectedItem instanceof PsiClass && (dtoPsi = (PsiClass)selectedItem).getName() != null && String.valueOf(dtoPsi).equals(input) ? dtoPsi : ResponseServiceUtils.getDtoByName(this.project, this.module, String.valueOf(selectedItem));
        String entityName = null;
        if (dtoPsiClass != null) {
            entityName = ResponseServiceUtils.getEntityByDto(dtoPsiClass, this.module).map(PsiQualifiedNamedElement::getName).orElse(null);
        }
        entityField.setEnabled(true);
        if (dtoPsiClass != null) {
            entityField.setEnabled(false);
            entityField.setSelectedItem((Object)entityName);
        }
    }

    private void drawPanel(Panel panel, ResponseServiceType responseServiceType) {
        JPanel jbPanel = (JPanel)this.panel.get(panel);
        jbPanel.removeAll();
        Arrays.stream(Fields.values()).filter(f -> f.getPanel().equals(panel)).filter(f -> f.getApplicableType().contains(responseServiceType)).sorted(Comparator.comparingInt(Fields::getOrder)).forEach(f -> {
            jbPanel.add(this.fields.get(f));
            jbPanel.add(Box.createVerticalStrut(6));
        });
        jbPanel.repaint();
        jbPanel.revalidate();
    }

    public BcDialogCreationData getValues() {
        ResponseServiceType selectedItem = (ResponseServiceType)this.fields.get(Fields.TYPE_SERVICE).getTypedInputElement(EnumComboBox.class).getSelectedItem();
        BcDialogCreationData.Builder builder = new BcDialogCreationData.Builder().bcName(this.name).serviceType(selectedItem).parentBcName((PsiEnumConstant)this.fields.get(Fields.PARENT_BC).getTypedInputElement(ComboBox.class).getSelectedItem()).isNewService(true);
        if (ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE.equals(selectedItem)) {
            this.filVersionAwareData(builder);
        }
        if (ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE.equals(selectedItem)) {
            this.fillAnySourceData(builder);
        }
        return builder.build();
    }

    private void filVersionAwareData(BcDialogCreationData.Builder builder) {
        PsiClass psiClass;
        String data;
        Object object = this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.entityClzName(data);
        } else {
            object = this.fields.get(Fields.ENTITY_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.entityClzName(psiClass.getName());
            }
        }
        object = this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.dtoClzName(data);
        } else {
            object = this.fields.get(Fields.DTO_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.dtoClzName(psiClass.getName());
            }
        }
        object = this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.serviceClzName(data);
        } else {
            object = this.fields.get(Fields.SERVICE_VERSION_AWARE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.serviceClzName(psiClass.getName()).isNewService(false);
            }
        }
    }

    private void fillAnySourceData(BcDialogCreationData.Builder builder) {
        PsiClass psiClass;
        String data;
        Object object = this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.dtoClzName(data);
            builder.entityClzName(data);
        } else {
            object = this.fields.get(Fields.DTO_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.dtoClzName(psiClass.getName());
                builder.entityClzName(psiClass.getName());
            }
        }
        object = this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
        if (object instanceof String) {
            data = (String)object;
            builder.serviceClzName(data);
        } else {
            object = this.fields.get(Fields.SERVICE_ANY_SOURCE).getTypedInputElement(ComboBox.class).getEditor().getItem();
            if (object instanceof PsiClass) {
                psiClass = (PsiClass)object;
                builder.serviceClzName(psiClass.getName()).isNewService(false);
            }
        }
    }

    public static enum Panel implements UiNamedComponent
    {
        MAIN,
        BC_CREATION,
        BC_PARENT;


        @Override
        public String getName() {
            return this.name();
        }
    }

    public static enum Fields implements UiNamedComponent
    {
        TYPE_SERVICE(Panel.MAIN, Arrays.asList(ResponseServiceType.values()), true, 0, () -> new JBLabel("Type service"), (m, n) -> new EnumComboBox<ResponseServiceType>(m.fieldsSuggestionData().types()), () -> new JBLabel("Please choose service type")),
        SERVICE_VERSION_AWARE(Panel.BC_CREATION, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), true, 1, () -> new JBLabel("Service name: "), (m, n) -> PanelWithTextAndInputAndSuggestion.createComboBox(m.fieldsSuggestionData().versionAwareServices(), n + ElementPostfix.SERVICE.getName(), PsiClass.class, PsiQualifiedNamedElement::getName), () -> new JBLabel("Start typing or choose existing.")),
        ENTITY_VERSION_AWARE(Panel.BC_CREATION, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), true, 2, () -> new JBLabel("Entity name: "), (m, n) -> PanelWithTextAndInputAndSuggestion.createComboBox(m.fieldsSuggestionData().entities(), n + ElementPostfix.ENTITY.getName(), PsiClass.class, PsiQualifiedNamedElement::getName), () -> new JBLabel("Start typing or choose existing.")),
        DTO_VERSION_AWARE(Panel.BC_CREATION, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), true, 3, () -> new JBLabel("DTO name: "), (m, n) -> PanelWithTextAndInputAndSuggestion.createComboBox(m.fieldsSuggestionData().dtos(), n + ElementPostfix.DTO.getName(), PsiClass.class, PsiQualifiedNamedElement::getName), () -> new JBLabel("Start typing or choose existing.")),
        SERVICE_ANY_SOURCE(Panel.BC_CREATION, List.of(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE), true, 1, () -> new JBLabel("Service name: "), (m, n) -> PanelWithTextAndInputAndSuggestion.createComboBox(m.fieldsSuggestionData().anySourceServices(), n + ElementPostfix.SERVICE.getName(), PsiClass.class, PsiQualifiedNamedElement::getName), () -> new JBLabel("Start typing or choose existing.")),
        ENTITY_ANY_SOURCE(Panel.BC_CREATION, List.of(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE), true, 2, () -> new JBLabel("Entity name: "), (m, n) -> PanelWithTextAndInputAndSuggestion.createComboBox(m.fieldsSuggestionData().entities(), n + ElementPostfix.ENTITY.getName(), PsiClass.class, PsiQualifiedNamedElement::getName), () -> new JBLabel("Is equals is DTO field or got from service")),
        DTO_ANY_SOURCE(Panel.BC_CREATION, List.of(ResponseServiceType.ANY_SOURCE_VERSION_AWARE_RESPONSE_SERVICE), true, 3, () -> new JBLabel("DTO name: "), (m, n) -> PanelWithTextAndInputAndSuggestion.createComboBox(m.fieldsSuggestionData().dtos(), n + ElementPostfix.DTO.getName(), PsiClass.class, PsiQualifiedNamedElement::getName), () -> new JBLabel("Start typing or choose existing.")),
        PARENT_BC(Panel.BC_PARENT, Arrays.asList(ResponseServiceType.values()), true, 10, () -> new JBLabel("Parent bc"), (m, n) -> new PsiEnumConstantComboBox(m.module()), () -> new JBLabel("Start typing to suggestion. <None> for empty bc parent")),
        TYPE_RELATIONSHIP(Panel.BC_PARENT, List.of(ResponseServiceType.VERSION_AWARE_RESPONSE_SERVICE), false, 11, () -> new JBLabel("Relationship type"), (m, n) -> new EnumComboBox<RelationshipEntityType>(Arrays.asList(RelationshipEntityType.values())), () -> new JBLabel("Relationship type"));

        private final List<ResponseServiceType> applicableType;
        private final UiNamedComponent panel;
        private final boolean isVisible;
        private final int order;
        private final Supplier<JBLabel> nameSupplier;
        private final BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> inputSupplier;
        private final Supplier<JBLabel> labelSupplier;

        private Fields(UiNamedComponent panel, List<ResponseServiceType> applicableType, boolean isVisible, int order, Supplier<JBLabel> nameSupplier, BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> input, Supplier<JBLabel> labelSupplier) {
            this.applicableType = applicableType;
            this.panel = panel;
            this.isVisible = isVisible;
            this.order = order;
            this.nameSupplier = nameSupplier;
            this.inputSupplier = input;
            this.labelSupplier = labelSupplier;
        }

        @Override
        public String getName() {
            return this.name();
        }

        public List<ResponseServiceType> getApplicableType() {
            return this.applicableType;
        }

        public UiNamedComponent getPanel() {
            return this.panel;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public Supplier<JBLabel> nameSupplier() {
            return this.nameSupplier;
        }

        public BiFunction<BCInspection.FixWithCreationBc.BcCreationMetaData, String, JComponent> providerSupplier() {
            return this.inputSupplier;
        }

        public Supplier<JBLabel> labelSupplier() {
            return this.labelSupplier;
        }
    }
}

