/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJvmModifiersOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.common.util.CreClassesFqn;
import org.cxbox.intellij.community.common.util.JavaUtil;
import org.cxbox.intellij.community.common.util.SearchScopeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cache {
    public static final String PLATFORM_1 = new String(Base64.getDecoder().decode("aW8udGVzbGVy"));
    public static final String PLATFORM_2 = "org.cxbox";

    public static List<String> getAllPossiblePlatformRootPackageWithoutDot() {
        return List.of(PLATFORM_1, PLATFORM_2);
    }

    @NotNull
    public static String getPlatformRootPackageWithoutDot(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            Cache.$$$reportNull$$$0(0);
        }
        if (module == null) {
            Cache.$$$reportNull$$$0(1);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        String string = (String)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getPlatformRootPackageWithoutDotNoCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
        if (string == null) {
            Cache.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String getPlatformRootPackageWithoutDotOrElseNull(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            Cache.$$$reportNull$$$0(3);
        }
        if (module == null) {
            Cache.$$$reportNull$$$0(4);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (String)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getPlatformRootPackageWithoutDotNoCacheOrElseNull(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    @NotNull
    private static String getPlatformRootPackageWithoutDotNoCache(@NotNull Module module) {
        String platform1;
        if (module == null) {
            Cache.$$$reportNull$$$0(5);
        }
        if ((platform1 = Cache.getPlatformRootPackageWithoutDotNoCacheOrElseNull(module)) != null) {
            String string = platform1;
            if (string == null) {
                Cache.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = PLATFORM_1;
        if (string == null) {
            Cache.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getPlatformRootPackageWithoutDotNoCacheOrElseNull(@NotNull Module module) {
        if (module == null) {
            Cache.$$$reportNull$$$0(8);
        }
        Project project = module.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        PsiClass baseClass = javaPsiFacade.findClass(PLATFORM_1 + CreClassesFqn.BASE_ENTITY_FQN_WITHOUT_PLATFORM.getValue(), scp);
        if (baseClass != null) {
            return PLATFORM_1;
        }
        baseClass = javaPsiFacade.findClass(PLATFORM_2 + CreClassesFqn.BASE_ENTITY_FQN_WITHOUT_PLATFORM.getValue(), scp);
        if (baseClass != null) {
            return PLATFORM_2;
        }
        return null;
    }

    @NotNull
    public static String getPersistenceVersionWithoutDot(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            Cache.$$$reportNull$$$0(9);
        }
        if (module == null) {
            Cache.$$$reportNull$$$0(10);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        String string = (String)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getPersistenceVersionWithoutDotNoCache(project, module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
        if (string == null) {
            Cache.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String getPersistenceVersionWithoutDotNoCache(@NotNull Project project, @NotNull Module module) {
        PsiClass baseEntity;
        if (project == null) {
            Cache.$$$reportNull$$$0(12);
        }
        if (module == null) {
            Cache.$$$reportNull$$$0(13);
        }
        if ((baseEntity = Cache.findPsiClassByName(Cache.getPlatformRootPackageWithoutDot(project, module) + CreClassesFqn.BASE_ENTITY_FQN_WITHOUT_PLATFORM.getValue(), module)) != null) {
            String string = Arrays.stream(baseEntity.getAllFields()).filter(field -> field.getName().endsWith("id")).map(PsiJvmModifiersOwner::getAnnotations).flatMap(Arrays::stream).map(PsiAnnotation::getQualifiedName).filter(Objects::nonNull).filter(annotationName -> annotationName.endsWith(".Id")).map(annotationName -> annotationName.replace(".Id", "")).findAny().orElse("jakarta.persistence");
            if (string == null) {
                Cache.$$$reportNull$$$0(14);
            }
            return string;
        }
        return "jakarta.persistence";
    }

    @Nullable
    public static PsiClass findPsiClassByName(String name, Module module) {
        Project project = module.getProject();
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scp = SearchScopeUtil.getModuleSearchScopeWithParentsAndChildsAndLibraries(module, module.getProject());
        return javaPsiFacade.findClass(name, scp);
    }

    public static boolean isOldApiService(@NotNull Project project, @NotNull Module module) {
        if (project == null) {
            Cache.$$$reportNull$$$0(15);
        }
        if (module == null) {
            Cache.$$$reportNull$$$0(16);
        }
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (Boolean)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.isOldApiServiceWithoutCache(module), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static boolean isOldApiServiceWithoutCache(Module module) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".core.crudma.impl.VersionAwareResponseService", GlobalSearchScope.allScope((Project)module.getProject()));
        return Optional.ofNullable(psiClass).map(PsiClass::getConstructors).stream().flatMap(Arrays::stream).noneMatch(constructor -> constructor.getParameterList().getParameters().length == 0);
    }

    public static PsiClass getBaseEntityClass(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".model.core.entity.BaseEntity"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    public static PsiClass getBaseEntityMetaModelClass(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".model.core.entity.BaseEntity_"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    public static PsiClass getVersionAwareServiceClass(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".core.crudma.impl.VersionAwareResponseService"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    public static PsiClass getVersionAwareMetaBuilderClass(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".core.service.rowmeta.FieldMetaBuilder"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    public static PsiClass getAnySourceMetaBuilderClass(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".core.service.rowmeta.AnySourceFieldMetaBuilder"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    public static PsiClass getJpaDAOClass(@NotNull Module module) {
        if (module == null) {
            Cache.$$$reportNull$$$0(17);
        }
        return Cache.findPsiClassByName(Cache.getPlatformRootPackageWithoutDot(module.getProject(), module) + ".model.core.dao.JpaDao", module);
    }

    public static PsiClass getAnySourceServiceClass(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".core.crudma.impl.AnySourceVersionAwareResponseService"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    public static PsiClass getFieldsCommonMeta(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".core.dto.rowmeta.FieldsCommonMeta"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    public static PsiClass getDataResponseDTOClass(Project project, Module module) {
        CachedValuesManager valuesManager = CachedValuesManager.getManager((Project)project);
        return (PsiClass)valuesManager.getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)Cache.getBaseClassWithoutCache(project, module, ".api.data.dto.DataResponseDTO"), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)module.getProject())}));
    }

    private static PsiClass getBaseClassWithoutCache(Project project, Module module, String className) {
        String clzFQN = Cache.getPlatformRootPackageWithoutDot(project, module) + className;
        return JavaUtil.getClassFromProjectAndLibrariesByFqn(project, module, clzFQN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/cxbox/intellij/community/common/Cache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/cxbox/intellij/community/common/Cache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformRootPackageWithoutDot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformRootPackageWithoutDotNoCache";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceVersionWithoutDot";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceVersionWithoutDotNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRootPackageWithoutDot";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRootPackageWithoutDotOrElseNull";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRootPackageWithoutDotNoCache";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRootPackageWithoutDotNoCacheOrElseNull";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceVersionWithoutDot";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceVersionWithoutDotNoCache";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isOldApiService";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getJpaDAOClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 11, 14 -> new IllegalStateException(string);
        };
    }
}

