/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.bc.ui.component;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.cxbox.intellij.community.wigdet.bc.BCInspection;
import org.cxbox.intellij.community.wigdet.bc.ui.component.PanelComponent;
import org.cxbox.intellij.community.wigdet.bc.ui.component.SuggestionPanel;
import org.jetbrains.annotations.NotNull;

public class PanelWithTextAndInputAndSuggestionElement
extends PanelComponent {
    private static final int LABEL_WIDTH = 130;
    private static final int INPUT_WIDTH = 250;
    private final JComponent labelName;
    private final JComponent input;
    private final JComponent suggestion;
    private boolean state = false;

    public PanelWithTextAndInputAndSuggestionElement(JComponent labelName, JComponent component, JComponent labelHelper) {
        super(new GridBagLayout(), new HashMap<JComponent, Map<String, Object>>());
        this.labelName = labelName;
        this.suggestion = labelHelper;
        this.input = component;
        if (labelHelper instanceof SuggestionPanel) {
            SuggestionPanel sp = (SuggestionPanel)labelHelper;
            sp.setState(true);
        }
        this.getState().put(labelHelper, new HashMap());
        this.getState().put(this.input, new HashMap());
        this.getState().put(this.suggestion, new HashMap());
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.labelName.setPreferredSize(new Dimension(130, this.labelName.getPreferredSize().height));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = JBUI.insetsRight((int)8);
        this.add((Component)this.labelName, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.add((Component)this.input, gbc);
        this.input.setSize(new Dimension(250, this.input.getPreferredSize().height));
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = JBUI.insets((int)2, (int)2, (int)0, (int)0);
        gbc.fill = 0;
        this.add((Component)this.suggestion, gbc);
        this.suggestion.setForeground((Color)JBColor.GRAY);
        this.suggestion.setFont(this.input.getFont().deriveFont(2, this.input.getFont().getSize() - 2));
    }

    @Override
    public JComponent getLabelName() {
        return this.labelName;
    }

    @Override
    public JComponent getInputComponent() {
        return this.input;
    }

    @Override
    public JComponent getLabelHelper() {
        return this.suggestion;
    }

    public JComponent getSuggestion() {
        return this.suggestion;
    }

    @Override
    public <T extends JComponent> T getTypedInputElement(Class<T> clazz) {
        return (T)((JComponent)clazz.cast(this.getInputComponent()));
    }

    @Override
    public <T extends JComponent> T getTypedInputElement() {
        return (T)this.getInputComponent();
    }

    public static <T> ComboBox<T> createComboBox(Collection<T> data, String value, final Class<T> clazz, final Function<T, String> nameFunction) {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel(new ArrayList<T>(data)));
        comboBox.setSwingPopup(false);
        comboBox.setPreferredSize(new Dimension(250, comboBox.getPreferredSize().height));
        comboBox.setEditable(true);
        comboBox.setSelectedItem((Object)value);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<T>(){

            protected void customizeCellRenderer(@NotNull JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
                PsiClass psiValue;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof PsiClass && (psiValue = (PsiClass)value).getQualifiedName() != null) {
                    this.append(psiValue.getQualifiedName());
                }
                SpeedSearchUtil.applySpeedSearchHighlighting(list, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/cxbox/intellij/community/wigdet/bc/ui/component/PanelWithTextAndInputAndSuggestionElement$1", "customizeCellRenderer"));
            }
        });
        comboBox.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){
            private T currentItem;
            private Class<T> tClass;
            private Function<T, String> functionGetName;
            {
                this.tClass = clazz;
                this.functionGetName = nameFunction;
            }

            @Override
            public Object getItem() {
                String editorText = this.editor.getText();
                if (this.tClass.isInstance(this.currentItem) && editorText.equals(this.functionGetName.apply(this.currentItem))) {
                    return this.currentItem;
                }
                return editorText;
            }

            @Override
            public void setItem(Object item) {
                String text;
                this.currentItem = this.tClass.isInstance(item) ? item : null;
                if (item instanceof PsiClass) {
                    PsiClass psi = (PsiClass)item;
                    super.setItem(psi);
                    text = psi.getQualifiedName();
                } else {
                    super.setItem(item);
                    text = String.valueOf(item);
                }
                this.editor.setText(text);
            }
        });
        return comboBox;
    }

    public static JComponent createSuggestion(Project project, String text, BCInspection.FixWithCreationBc.BcCreationMetaData metaData) {
        return new SuggestionPanel(project, text, metaData);
    }
}

