/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.commonProps.key;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Triple;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonElementGenerator;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldKeyNonHiddenButNotAddedToLayoutInspection
extends LocalInspectionTool {
    private boolean isCheckedWidgetType(JsonStringLiteral type) {
        return type.getValue() != null && JWidget.getFormLikeWidgetTypes().contains(type.getValue());
    }

    @NotNull
    public String getShortName() {
        return "FieldKeyNonHiddenButNotAddedToLayoutInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            FieldKeyNonHiddenButNotAddedToLayoutInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FieldKeyNonHiddenButNotAddedToLayoutInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        List<Triple<String, JsonObject, JsonArray>> fieldNameToObjectList = JWidget.getWidgetFields((JsonFile)file);
        fieldNameToObjectList.forEach(arg_0 -> this.lambda$checkFile$0(manager, (List)descriptors, file, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void check(@NotNull InspectionManager manager, List<ProblemDescriptor> descriptors, Triple<String, JsonObject, JsonArray> fieldNameToObject, JsonFile jsonFile) {
        if (manager == null) {
            FieldKeyNonHiddenButNotAddedToLayoutInspection.$$$reportNull$$$0(2);
        }
        AtomicBoolean existsAmongFieldKeys = new AtomicBoolean(false);
        String fieldName = (String)fieldNameToObject.getLeft();
        JsonObject fieldObject = (JsonObject)fieldNameToObject.getMiddle();
        JsonStringLiteral fieldNamePsi = JsonFacade.safeGetPropertyValueOfType(fieldObject, JWidget.FIELDS_KEY);
        if (JWidget.isFieldHidden(fieldObject)) {
            return;
        }
        if (JWidget.isFieldInsideMultifield(fieldObject)) {
            return;
        }
        JsonObject topLevelValue = JsonFacade.getTopLevelObject(jsonFile);
        JsonStringLiteral type = JsonFacade.safeGetPropertyValueOfType(topLevelValue, JWidget.TYPE);
        if (type == null || !this.isCheckedWidgetType(type)) {
            return;
        }
        JWidget.visitWidgetLayoutFieldKeys(topLevelValue, (Consumer<JsonStringLiteral>)((Consumer)fieldKey -> {
            if (fieldKey != null && Objects.equals(fieldKey.getValue(), fieldName)) {
                existsAmongFieldKeys.set(true);
            }
        }));
        if (fieldNamePsi != null && !existsAmongFieldKeys.get()) {
            descriptors.add(manager.createProblemDescriptor((PsiElement)fieldNamePsi, new TextRange(1, fieldNamePsi.getValue().length() + 1), "Field not referenced in layout. Fields must be either hidden or referenced in layout", ProblemHighlightType.GENERIC_ERROR, true, new LocalQuickFix[]{new Fix(fieldName)}));
        }
    }

    private /* synthetic */ void lambda$checkFile$0(InspectionManager manager, List descriptors, PsiFile file, Triple fieldNameToObject) {
        this.check(manager, descriptors, (Triple<String, JsonObject, JsonArray>)fieldNameToObject, (JsonFile)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/key/FieldKeyNonHiddenButNotAddedToLayoutInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Fix
    implements LocalQuickFix {
        final String fieldName;

        private Fix(@Nullable String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean availableInBatchMode() {
            return true;
        }

        @NotNull
        public String getName() {
            return "Add to layout (press -> to apply fix for whole file)";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Add to layout";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                Fix.$$$reportNull$$$0(1);
            }
            PsiElement element = descriptor.getPsiElement();
            PsiFile file = element.getContainingFile();
            JsonFile jsonFile = (JsonFile)file;
            JsonObject topLevelValue = JsonFacade.getTopLevelObject(jsonFile);
            JsonObject options = JsonFacade.safeGetPropertyValueOfType(topLevelValue, JWidget.OPTIONS);
            JsonObject layout = JsonFacade.safeGetPropertyValueOfType(options, JWidget.LAYOUT);
            JsonArray rows = JsonFacade.safeGetPropertyValueOfType(layout, JWidget.LAYOUT_ROWS);
            CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> {
                String newRowValue = "\n          \"cols\": [\n            {\n              \"fieldKey\": \"" + this.fieldName + "\",\n              \"span\": 12\n            }\n          ]\n        ";
                JsonElementGenerator json = new JsonElementGenerator(project);
                JsonObject newRowObject = json.createObject(newRowValue);
                JsonArray rowsValue = json.createArrayOfObjects(List.of(newRowObject.getText()));
                JsonProperty rowsProperty = json.createProperty(JWidget.LAYOUT_ROWS.getName(), rowsValue.getText());
                JsonObject layoutValue = json.createObject(rowsProperty.getText());
                JsonProperty layoutProperty = json.createProperty(JWidget.LAYOUT.getName(), layoutValue.getText());
                JsonObject optionsValue = json.createObject(layoutProperty.getText());
                JsonProperty optionsProperty = json.createProperty(JWidget.OPTIONS.getName(), optionsValue.getText());
                if (rows != null) {
                    if (!rows.getValueList().isEmpty()) {
                        rows.addBefore((PsiElement)newRowObject, (PsiElement)rows.getValueList().get(0));
                        rows.addAfter(json.createComma(), (PsiElement)rows.getValueList().get(0));
                    } else {
                        rows.replace((PsiElement)rowsValue);
                    }
                } else if (layout != null) {
                    if (!layout.getPropertyList().isEmpty()) {
                        layout.addBefore((PsiElement)rowsProperty, (PsiElement)layout.getPropertyList().get(0));
                        layout.addAfter(json.createComma(), (PsiElement)layout.getPropertyList().get(0));
                    } else {
                        layout.replace((PsiElement)layoutValue);
                    }
                } else if (options != null) {
                    if (!options.getPropertyList().isEmpty()) {
                        options.addBefore((PsiElement)layoutProperty, (PsiElement)options.getPropertyList().get(0));
                        options.addAfter(json.createComma(), (PsiElement)options.getPropertyList().get(0));
                    } else {
                        options.replace((PsiElement)optionsValue);
                    }
                } else if (topLevelValue != null && !topLevelValue.getPropertyList().isEmpty()) {
                    topLevelValue.addAfter((PsiElement)optionsProperty, (PsiElement)topLevelValue.getPropertyList().get(topLevelValue.getPropertyList().size() - 1));
                    topLevelValue.addBefore(json.createComma(), (PsiElement)topLevelValue.getPropertyList().get(topLevelValue.getPropertyList().size() - 1));
                }
            });
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file.getContainingFile());
            QuickFixUtils.safeDoPostponedOperationsIfPossible(project, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/key/FieldKeyNonHiddenButNotAddedToLayoutInspection$Fix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

