/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.intellij.community.wigdet.fields.field.commonProps.key;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cxbox.intellij.community.common.conf.JWidget;
import org.cxbox.intellij.community.common.util.JsonFacade;
import org.cxbox.intellij.community.common.util.QuickFixUtils;
import org.cxbox.intellij.community.common.util.ResponseServiceUtils;
import org.cxbox.intellij.community.wigdet.fields.AwareResponseServiceType;
import org.cxbox.intellij.community.wigdet.fields.StandardFieldType;
import org.cxbox.intellij.community.wigdet.fields.field.AddNewFieldFix;
import org.cxbox.intellij.community.wigdet.fields.field.commonProps.key.FieldKeyReferenceContributor;
import org.cxbox.intellij.community.wigdet.fields.field.commonProps.key.FieldKeyReferenceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldKeyInspection
extends LocalInspectionTool {
    public static final int MAX_TRIES_TO_FIND_NOT_CONFLICTING_FILE_NAME = 10000;

    @NotNull
    public String getShortName() {
        return "FieldKeyInspection";
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            FieldKeyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            FieldKeyInspection.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().endsWith(".widget.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = file.getProject();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SmartList descriptors = new SmartList();
        Arrays.stream(file.getChildren()).filter(Objects::nonNull).forEach(arg_0 -> this.lambda$checkFile$0(manager, (List)descriptors, project, module, arg_0));
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void extracted(@NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> descriptors, @Nullable PsiElement c, @NotNull Project project, @NotNull Module module) {
        if (manager == null) {
            FieldKeyInspection.$$$reportNull$$$0(2);
        }
        if (descriptors == null) {
            FieldKeyInspection.$$$reportNull$$$0(3);
        }
        if (project == null) {
            FieldKeyInspection.$$$reportNull$$$0(4);
        }
        if (module == null) {
            FieldKeyInspection.$$$reportNull$$$0(5);
        }
        if (FieldKeyReferenceContributor.Holder.WIDGET_DTO_FIELD_REF_PATTERN.accepts((Object)c) && c instanceof JsonStringLiteral) {
            JsonStringLiteral jsonC = (JsonStringLiteral)c;
            Optional link = (Optional)FieldKeyReferenceProvider.getLinkAndAutocompletionByRestResourceName(jsonC, project, module).getFirst();
            JsonProperty tagProperty = JsonFacade.getParentOfType(c, JsonProperty.class);
            String fieldType = JWidget.getFieldType(tagProperty);
            PsiFile file = c.getContainingFile();
            AwareResponseServiceType awareResponseServiceType = ResponseServiceUtils.getServiceTypeFromJsonWidgetFile(file);
            if (link.isEmpty()) {
                if (fieldType != null && StandardFieldType.getByFieldType(fieldType).map(t -> StandardFieldType.getGeneratorClz(t, awareResponseServiceType)).map(e -> !e.isEmpty()).orElse(false).booleanValue()) {
                    descriptors.add(manager.createProblemDescriptor(c, new TextRange(1, jsonC.getValue().length() + 1), "Key references not existing dto field - fix can create new field and auto-generate other necessary code", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new AddNewFieldFix()}));
                } else {
                    descriptors.add(manager.createProblemDescriptor(c, new TextRange(1, jsonC.getValue().length() + 1), "Key references not existing dto field - fix will clean value and suggest autocomplete", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, true, new LocalQuickFix[]{new FixUseAutoComplete()}));
                }
            }
        } else {
            Arrays.stream(c.getChildren()).forEach(c2 -> this.extracted(manager, descriptors, (PsiElement)c2, project, module));
        }
    }

    private /* synthetic */ void lambda$checkFile$0(InspectionManager manager, List descriptors, Project project, Module module, PsiElement c) {
        this.extracted(manager, descriptors, c, project, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/key/FieldKeyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extracted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FixUseAutoComplete
    implements LocalQuickFix {
        private FixUseAutoComplete() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            return "Select correct value";
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            return "Select correct value";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                FixUseAutoComplete.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                FixUseAutoComplete.$$$reportNull$$$0(1);
            }
            QuickFixUtils.clearJsonStringLiteralValueAndInvokeAutoCompliteIfPossible(project, descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/cxbox/intellij/community/wigdet/fields/field/commonProps/key/FieldKeyInspection$FixUseAutoComplete";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

